/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.carbonoptimization.fluent.CarbonServicesClient;
import com.azure.resourcemanager.carbonoptimization.fluent.models.CarbonEmissionDataAvailableDateRangeInner;
import com.azure.resourcemanager.carbonoptimization.fluent.models.CarbonEmissionDataListResultInner;
import com.azure.resourcemanager.carbonoptimization.implementation.CarbonOptimizationManagementClientImpl;
import com.azure.resourcemanager.carbonoptimization.models.QueryFilter;
import reactor.core.publisher.Mono;

public final class CarbonServicesClientImpl
implements CarbonServicesClient {
    private final CarbonServicesService service;
    private final CarbonOptimizationManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(CarbonServicesClientImpl.class);

    CarbonServicesClientImpl(CarbonOptimizationManagementClientImpl client) {
        this.service = (CarbonServicesService)RestProxy.create(CarbonServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CarbonEmissionDataListResultInner>> queryCarbonEmissionReportsWithResponseAsync(QueryFilter queryParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (queryParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryParameters is required and cannot be null."));
        }
        queryParameters.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.queryCarbonEmissionReports(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", "application/json", queryParameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CarbonEmissionDataListResultInner> queryCarbonEmissionReportsAsync(QueryFilter queryParameters) {
        return this.queryCarbonEmissionReportsWithResponseAsync(queryParameters).flatMap(res -> Mono.justOrEmpty((Object)((CarbonEmissionDataListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CarbonEmissionDataListResultInner> queryCarbonEmissionReportsWithResponse(QueryFilter queryParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (queryParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter queryParameters is required and cannot be null."));
        }
        queryParameters.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.queryCarbonEmissionReportsSync(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", "application/json", queryParameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CarbonEmissionDataListResultInner queryCarbonEmissionReports(QueryFilter queryParameters) {
        return (CarbonEmissionDataListResultInner)this.queryCarbonEmissionReportsWithResponse(queryParameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CarbonEmissionDataAvailableDateRangeInner>> queryCarbonEmissionDataAvailableDateRangeWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.queryCarbonEmissionDataAvailableDateRange(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CarbonEmissionDataAvailableDateRangeInner> queryCarbonEmissionDataAvailableDateRangeAsync() {
        return this.queryCarbonEmissionDataAvailableDateRangeWithResponseAsync().flatMap(res -> Mono.justOrEmpty((Object)((CarbonEmissionDataAvailableDateRangeInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CarbonEmissionDataAvailableDateRangeInner> queryCarbonEmissionDataAvailableDateRangeWithResponse(Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.queryCarbonEmissionDataAvailableDateRangeSync(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CarbonEmissionDataAvailableDateRangeInner queryCarbonEmissionDataAvailableDateRange() {
        return (CarbonEmissionDataAvailableDateRangeInner)this.queryCarbonEmissionDataAvailableDateRangeWithResponse(Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="CarbonOptimizationManagementClientCarbonServices")
    public static interface CarbonServicesService {
        @Post(value="/providers/Microsoft.Carbon/carbonEmissionReports")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CarbonEmissionDataListResultInner>> queryCarbonEmissionReports(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") QueryFilter var5, Context var6);

        @Post(value="/providers/Microsoft.Carbon/carbonEmissionReports")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CarbonEmissionDataListResultInner> queryCarbonEmissionReportsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") QueryFilter var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Carbon/queryCarbonEmissionDataAvailableDateRange")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CarbonEmissionDataAvailableDateRangeInner>> queryCarbonEmissionDataAvailableDateRange(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Carbon/queryCarbonEmissionDataAvailableDateRange")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CarbonEmissionDataAvailableDateRangeInner> queryCarbonEmissionDataAvailableDateRangeSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

