/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.CategoryTypeEnum;
import com.azure.resourcemanager.carbonoptimization.models.DateRange;
import com.azure.resourcemanager.carbonoptimization.models.EmissionScopeEnum;
import com.azure.resourcemanager.carbonoptimization.models.QueryFilter;
import com.azure.resourcemanager.carbonoptimization.models.ReportTypeEnum;
import java.io.IOException;
import java.util.List;

public final class TopItemsMonthlySummaryReportQueryFilter
extends QueryFilter {
    private ReportTypeEnum reportType = ReportTypeEnum.TOP_ITEMS_MONTHLY_SUMMARY_REPORT;
    private CategoryTypeEnum categoryType;
    private int topItems;
    private static final ClientLogger LOGGER = new ClientLogger(TopItemsMonthlySummaryReportQueryFilter.class);

    @Override
    public ReportTypeEnum reportType() {
        return this.reportType;
    }

    public CategoryTypeEnum categoryType() {
        return this.categoryType;
    }

    public TopItemsMonthlySummaryReportQueryFilter withCategoryType(CategoryTypeEnum categoryType) {
        this.categoryType = categoryType;
        return this;
    }

    public int topItems() {
        return this.topItems;
    }

    public TopItemsMonthlySummaryReportQueryFilter withTopItems(int topItems) {
        this.topItems = topItems;
        return this;
    }

    @Override
    public TopItemsMonthlySummaryReportQueryFilter withDateRange(DateRange dateRange) {
        super.withDateRange(dateRange);
        return this;
    }

    @Override
    public TopItemsMonthlySummaryReportQueryFilter withSubscriptionList(List<String> subscriptionList) {
        super.withSubscriptionList(subscriptionList);
        return this;
    }

    @Override
    public TopItemsMonthlySummaryReportQueryFilter withResourceGroupUrlList(List<String> resourceGroupUrlList) {
        super.withResourceGroupUrlList(resourceGroupUrlList);
        return this;
    }

    @Override
    public TopItemsMonthlySummaryReportQueryFilter withResourceTypeList(List<String> resourceTypeList) {
        super.withResourceTypeList(resourceTypeList);
        return this;
    }

    @Override
    public TopItemsMonthlySummaryReportQueryFilter withLocationList(List<String> locationList) {
        super.withLocationList(locationList);
        return this;
    }

    @Override
    public TopItemsMonthlySummaryReportQueryFilter withCarbonScopeList(List<EmissionScopeEnum> carbonScopeList) {
        super.withCarbonScopeList(carbonScopeList);
        return this;
    }

    @Override
    public void validate() {
        if (this.categoryType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property categoryType in model TopItemsMonthlySummaryReportQueryFilter"));
        }
        if (this.dateRange() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dateRange in model TopItemsMonthlySummaryReportQueryFilter"));
        }
        this.dateRange().validate();
        if (this.subscriptionList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionList in model TopItemsMonthlySummaryReportQueryFilter"));
        }
        if (this.carbonScopeList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property carbonScopeList in model TopItemsMonthlySummaryReportQueryFilter"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dateRange", (JsonSerializable)this.dateRange());
        jsonWriter.writeArrayField("subscriptionList", this.subscriptionList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("carbonScopeList", this.carbonScopeList(), (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("resourceGroupUrlList", this.resourceGroupUrlList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("resourceTypeList", this.resourceTypeList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("locationList", this.locationList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("categoryType", this.categoryType == null ? null : this.categoryType.toString());
        jsonWriter.writeIntField("topItems", this.topItems);
        jsonWriter.writeStringField("reportType", this.reportType == null ? null : this.reportType.toString());
        return jsonWriter.writeEndObject();
    }

    public static TopItemsMonthlySummaryReportQueryFilter fromJson(JsonReader jsonReader) throws IOException {
        return (TopItemsMonthlySummaryReportQueryFilter)jsonReader.readObject(reader -> {
            TopItemsMonthlySummaryReportQueryFilter deserializedTopItemsMonthlySummaryReportQueryFilter = new TopItemsMonthlySummaryReportQueryFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dateRange".equals(fieldName)) {
                    deserializedTopItemsMonthlySummaryReportQueryFilter.withDateRange(DateRange.fromJson(reader));
                    continue;
                }
                if ("subscriptionList".equals(fieldName)) {
                    List subscriptionList = reader.readArray(reader1 -> reader1.getString());
                    deserializedTopItemsMonthlySummaryReportQueryFilter.withSubscriptionList(subscriptionList);
                    continue;
                }
                if ("carbonScopeList".equals(fieldName)) {
                    List carbonScopeList = reader.readArray(reader1 -> EmissionScopeEnum.fromString(reader1.getString()));
                    deserializedTopItemsMonthlySummaryReportQueryFilter.withCarbonScopeList(carbonScopeList);
                    continue;
                }
                if ("resourceGroupUrlList".equals(fieldName)) {
                    List resourceGroupUrlList = reader.readArray(reader1 -> reader1.getString());
                    deserializedTopItemsMonthlySummaryReportQueryFilter.withResourceGroupUrlList(resourceGroupUrlList);
                    continue;
                }
                if ("resourceTypeList".equals(fieldName)) {
                    List resourceTypeList = reader.readArray(reader1 -> reader1.getString());
                    deserializedTopItemsMonthlySummaryReportQueryFilter.withResourceTypeList(resourceTypeList);
                    continue;
                }
                if ("locationList".equals(fieldName)) {
                    List locationList = reader.readArray(reader1 -> reader1.getString());
                    deserializedTopItemsMonthlySummaryReportQueryFilter.withLocationList(locationList);
                    continue;
                }
                if ("categoryType".equals(fieldName)) {
                    deserializedTopItemsMonthlySummaryReportQueryFilter.categoryType = CategoryTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("topItems".equals(fieldName)) {
                    deserializedTopItemsMonthlySummaryReportQueryFilter.topItems = reader.getInt();
                    continue;
                }
                if ("reportType".equals(fieldName)) {
                    deserializedTopItemsMonthlySummaryReportQueryFilter.reportType = ReportTypeEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTopItemsMonthlySummaryReportQueryFilter;
        });
    }
}

