/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionItemDetailData;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionMonthlySummaryData;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionOverallSummaryData;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionTopItemMonthlySummaryData;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionTopItemsSummaryData;
import com.azure.resourcemanager.carbonoptimization.models.ResourceCarbonEmissionItemDetailData;
import com.azure.resourcemanager.carbonoptimization.models.ResourceCarbonEmissionTopItemMonthlySummaryData;
import com.azure.resourcemanager.carbonoptimization.models.ResourceCarbonEmissionTopItemsSummaryData;
import com.azure.resourcemanager.carbonoptimization.models.ResourceGroupCarbonEmissionItemDetailData;
import com.azure.resourcemanager.carbonoptimization.models.ResourceGroupCarbonEmissionTopItemMonthlySummaryData;
import com.azure.resourcemanager.carbonoptimization.models.ResourceGroupCarbonEmissionTopItemsSummaryData;
import com.azure.resourcemanager.carbonoptimization.models.ResponseDataTypeEnum;
import java.io.IOException;

public class CarbonEmissionData
implements JsonSerializable<CarbonEmissionData> {
    private ResponseDataTypeEnum dataType = ResponseDataTypeEnum.fromString("CarbonEmissionData");
    private double latestMonthEmissions;
    private double previousMonthEmissions;
    private Double monthOverMonthEmissionsChangeRatio;
    private Double monthlyEmissionsChangeValue;

    protected CarbonEmissionData() {
    }

    public ResponseDataTypeEnum dataType() {
        return this.dataType;
    }

    public double latestMonthEmissions() {
        return this.latestMonthEmissions;
    }

    CarbonEmissionData withLatestMonthEmissions(double latestMonthEmissions) {
        this.latestMonthEmissions = latestMonthEmissions;
        return this;
    }

    public double previousMonthEmissions() {
        return this.previousMonthEmissions;
    }

    CarbonEmissionData withPreviousMonthEmissions(double previousMonthEmissions) {
        this.previousMonthEmissions = previousMonthEmissions;
        return this;
    }

    public Double monthOverMonthEmissionsChangeRatio() {
        return this.monthOverMonthEmissionsChangeRatio;
    }

    CarbonEmissionData withMonthOverMonthEmissionsChangeRatio(Double monthOverMonthEmissionsChangeRatio) {
        this.monthOverMonthEmissionsChangeRatio = monthOverMonthEmissionsChangeRatio;
        return this;
    }

    public Double monthlyEmissionsChangeValue() {
        return this.monthlyEmissionsChangeValue;
    }

    CarbonEmissionData withMonthlyEmissionsChangeValue(Double monthlyEmissionsChangeValue) {
        this.monthlyEmissionsChangeValue = monthlyEmissionsChangeValue;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("latestMonthEmissions", this.latestMonthEmissions);
        jsonWriter.writeDoubleField("previousMonthEmissions", this.previousMonthEmissions);
        jsonWriter.writeStringField("dataType", this.dataType == null ? null : this.dataType.toString());
        jsonWriter.writeNumberField("monthOverMonthEmissionsChangeRatio", (Number)this.monthOverMonthEmissionsChangeRatio);
        jsonWriter.writeNumberField("monthlyEmissionsChangeValue", (Number)this.monthlyEmissionsChangeValue);
        return jsonWriter.writeEndObject();
    }

    public static CarbonEmissionData fromJson(JsonReader jsonReader) throws IOException {
        return (CarbonEmissionData)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                CarbonEmissionData carbonEmissionData;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("dataType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("OverallSummaryData".equals(discriminatorValue)) {
                    carbonEmissionData = CarbonEmissionOverallSummaryData.fromJson(readerToUse.reset());
                    return carbonEmissionData;
                }
                if ("MonthlySummaryData".equals(discriminatorValue)) {
                    carbonEmissionData = CarbonEmissionMonthlySummaryData.fromJson(readerToUse.reset());
                    return carbonEmissionData;
                }
                if ("TopItemsSummaryData".equals(discriminatorValue)) {
                    carbonEmissionData = CarbonEmissionTopItemsSummaryData.fromJson(readerToUse.reset());
                    return carbonEmissionData;
                }
                if ("ResourceTopItemsSummaryData".equals(discriminatorValue)) {
                    carbonEmissionData = ResourceCarbonEmissionTopItemsSummaryData.fromJson(readerToUse.reset());
                    return carbonEmissionData;
                }
                if ("ResourceGroupTopItemsSummaryData".equals(discriminatorValue)) {
                    carbonEmissionData = ResourceGroupCarbonEmissionTopItemsSummaryData.fromJson(readerToUse.reset());
                    return carbonEmissionData;
                }
                if ("TopItemsMonthlySummaryData".equals(discriminatorValue)) {
                    carbonEmissionData = CarbonEmissionTopItemMonthlySummaryData.fromJson(readerToUse.reset());
                    return carbonEmissionData;
                }
                if ("ResourceTopItemsMonthlySummaryData".equals(discriminatorValue)) {
                    carbonEmissionData = ResourceCarbonEmissionTopItemMonthlySummaryData.fromJson(readerToUse.reset());
                    return carbonEmissionData;
                }
                if ("ResourceGroupTopItemsMonthlySummaryData".equals(discriminatorValue)) {
                    carbonEmissionData = ResourceGroupCarbonEmissionTopItemMonthlySummaryData.fromJson(readerToUse.reset());
                    return carbonEmissionData;
                }
                if ("ItemDetailsData".equals(discriminatorValue)) {
                    carbonEmissionData = CarbonEmissionItemDetailData.fromJson(readerToUse.reset());
                    return carbonEmissionData;
                }
                if ("ResourceItemDetailsData".equals(discriminatorValue)) {
                    carbonEmissionData = ResourceCarbonEmissionItemDetailData.fromJson(readerToUse.reset());
                    return carbonEmissionData;
                }
                if ("ResourceGroupItemDetailsData".equals(discriminatorValue)) {
                    carbonEmissionData = ResourceGroupCarbonEmissionItemDetailData.fromJson(readerToUse.reset());
                    return carbonEmissionData;
                }
                carbonEmissionData = CarbonEmissionData.fromJsonKnownDiscriminator(readerToUse.reset());
                return carbonEmissionData;
            }
        });
    }

    static CarbonEmissionData fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (CarbonEmissionData)jsonReader.readObject(reader -> {
            CarbonEmissionData deserializedCarbonEmissionData = new CarbonEmissionData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("latestMonthEmissions".equals(fieldName)) {
                    deserializedCarbonEmissionData.latestMonthEmissions = reader.getDouble();
                    continue;
                }
                if ("previousMonthEmissions".equals(fieldName)) {
                    deserializedCarbonEmissionData.previousMonthEmissions = reader.getDouble();
                    continue;
                }
                if ("dataType".equals(fieldName)) {
                    deserializedCarbonEmissionData.dataType = ResponseDataTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("monthOverMonthEmissionsChangeRatio".equals(fieldName)) {
                    deserializedCarbonEmissionData.monthOverMonthEmissionsChangeRatio = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("monthlyEmissionsChangeValue".equals(fieldName)) {
                    deserializedCarbonEmissionData.monthlyEmissionsChangeValue = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCarbonEmissionData;
        });
    }
}

