/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.carbonoptimization.CarbonOptimizationManager;
import com.azure.resourcemanager.carbonoptimization.fluent.CarbonServicesClient;
import com.azure.resourcemanager.carbonoptimization.fluent.models.CarbonEmissionDataAvailableDateRangeInner;
import com.azure.resourcemanager.carbonoptimization.fluent.models.CarbonEmissionDataListResultInner;
import com.azure.resourcemanager.carbonoptimization.implementation.CarbonEmissionDataAvailableDateRangeImpl;
import com.azure.resourcemanager.carbonoptimization.implementation.CarbonEmissionDataListResultImpl;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionDataAvailableDateRange;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionDataListResult;
import com.azure.resourcemanager.carbonoptimization.models.CarbonServices;
import com.azure.resourcemanager.carbonoptimization.models.QueryFilter;

public final class CarbonServicesImpl
implements CarbonServices {
    private static final ClientLogger LOGGER = new ClientLogger(CarbonServicesImpl.class);
    private final CarbonServicesClient innerClient;
    private final CarbonOptimizationManager serviceManager;

    public CarbonServicesImpl(CarbonServicesClient innerClient, CarbonOptimizationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CarbonEmissionDataListResult> queryCarbonEmissionReportsWithResponse(QueryFilter queryParameters, Context context) {
        Response<CarbonEmissionDataListResultInner> inner = this.serviceClient().queryCarbonEmissionReportsWithResponse(queryParameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CarbonEmissionDataListResultImpl((CarbonEmissionDataListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CarbonEmissionDataListResult queryCarbonEmissionReports(QueryFilter queryParameters) {
        CarbonEmissionDataListResultInner inner = this.serviceClient().queryCarbonEmissionReports(queryParameters);
        if (inner != null) {
            return new CarbonEmissionDataListResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<CarbonEmissionDataAvailableDateRange> queryCarbonEmissionDataAvailableDateRangeWithResponse(Context context) {
        Response<CarbonEmissionDataAvailableDateRangeInner> inner = this.serviceClient().queryCarbonEmissionDataAvailableDateRangeWithResponse(context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CarbonEmissionDataAvailableDateRangeImpl((CarbonEmissionDataAvailableDateRangeInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CarbonEmissionDataAvailableDateRange queryCarbonEmissionDataAvailableDateRange() {
        CarbonEmissionDataAvailableDateRangeInner inner = this.serviceClient().queryCarbonEmissionDataAvailableDateRange();
        if (inner != null) {
            return new CarbonEmissionDataAvailableDateRangeImpl(inner, this.manager());
        }
        return null;
    }

    private CarbonServicesClient serviceClient() {
        return this.innerClient;
    }

    private CarbonOptimizationManager manager() {
        return this.serviceManager;
    }
}

