/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.PowerStateEnum;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstanceStatusProvisioningStatus;
import java.io.IOException;

public final class VirtualMachineInstanceStatus
implements JsonSerializable<VirtualMachineInstanceStatus> {
    private String errorCode;
    private String errorMessage;
    private PowerStateEnum powerState;
    private VirtualMachineInstanceStatusProvisioningStatus provisioningStatus;

    private VirtualMachineInstanceStatus() {
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public PowerStateEnum powerState() {
        return this.powerState;
    }

    public VirtualMachineInstanceStatusProvisioningStatus provisioningStatus() {
        return this.provisioningStatus;
    }

    public void validate() {
        if (this.provisioningStatus() != null) {
            this.provisioningStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("errorCode", this.errorCode);
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        jsonWriter.writeStringField("powerState", this.powerState == null ? null : this.powerState.toString());
        jsonWriter.writeJsonField("provisioningStatus", (JsonSerializable)this.provisioningStatus);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineInstanceStatus fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineInstanceStatus)jsonReader.readObject(reader -> {
            VirtualMachineInstanceStatus deserializedVirtualMachineInstanceStatus = new VirtualMachineInstanceStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errorCode".equals(fieldName)) {
                    deserializedVirtualMachineInstanceStatus.errorCode = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedVirtualMachineInstanceStatus.errorMessage = reader.getString();
                    continue;
                }
                if ("powerState".equals(fieldName)) {
                    deserializedVirtualMachineInstanceStatus.powerState = PowerStateEnum.fromString(reader.getString());
                    continue;
                }
                if ("provisioningStatus".equals(fieldName)) {
                    deserializedVirtualMachineInstanceStatus.provisioningStatus = VirtualMachineInstanceStatusProvisioningStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineInstanceStatus;
        });
    }
}

