/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.ImageArmReference;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDiskArmReference;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstancePropertiesStorageProfileOsDisk;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineInstancePropertiesStorageProfile
implements JsonSerializable<VirtualMachineInstancePropertiesStorageProfile> {
    private List<VirtualHardDiskArmReference> dataDisks;
    private ImageArmReference imageReference;
    private VirtualMachineInstancePropertiesStorageProfileOsDisk osDisk;
    private String vmConfigStoragePathId;

    public List<VirtualHardDiskArmReference> dataDisks() {
        return this.dataDisks;
    }

    public VirtualMachineInstancePropertiesStorageProfile withDataDisks(List<VirtualHardDiskArmReference> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

    public ImageArmReference imageReference() {
        return this.imageReference;
    }

    public VirtualMachineInstancePropertiesStorageProfile withImageReference(ImageArmReference imageReference) {
        this.imageReference = imageReference;
        return this;
    }

    public VirtualMachineInstancePropertiesStorageProfileOsDisk osDisk() {
        return this.osDisk;
    }

    public VirtualMachineInstancePropertiesStorageProfile withOsDisk(VirtualMachineInstancePropertiesStorageProfileOsDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    public String vmConfigStoragePathId() {
        return this.vmConfigStoragePathId;
    }

    public VirtualMachineInstancePropertiesStorageProfile withVmConfigStoragePathId(String vmConfigStoragePathId) {
        this.vmConfigStoragePathId = vmConfigStoragePathId;
        return this;
    }

    public void validate() {
        if (this.dataDisks() != null) {
            this.dataDisks().forEach(e -> e.validate());
        }
        if (this.imageReference() != null) {
            this.imageReference().validate();
        }
        if (this.osDisk() != null) {
            this.osDisk().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("dataDisks", this.dataDisks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("imageReference", (JsonSerializable)this.imageReference);
        jsonWriter.writeJsonField("osDisk", (JsonSerializable)this.osDisk);
        jsonWriter.writeStringField("vmConfigStoragePathId", this.vmConfigStoragePathId);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineInstancePropertiesStorageProfile fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineInstancePropertiesStorageProfile)jsonReader.readObject(reader -> {
            VirtualMachineInstancePropertiesStorageProfile deserializedVirtualMachineInstancePropertiesStorageProfile = new VirtualMachineInstancePropertiesStorageProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataDisks".equals(fieldName)) {
                    List dataDisks;
                    deserializedVirtualMachineInstancePropertiesStorageProfile.dataDisks = dataDisks = reader.readArray(reader1 -> VirtualHardDiskArmReference.fromJson(reader1));
                    continue;
                }
                if ("imageReference".equals(fieldName)) {
                    deserializedVirtualMachineInstancePropertiesStorageProfile.imageReference = ImageArmReference.fromJson(reader);
                    continue;
                }
                if ("osDisk".equals(fieldName)) {
                    deserializedVirtualMachineInstancePropertiesStorageProfile.osDisk = VirtualMachineInstancePropertiesStorageProfileOsDisk.fromJson(reader);
                    continue;
                }
                if ("vmConfigStoragePathId".equals(fieldName)) {
                    deserializedVirtualMachineInstancePropertiesStorageProfile.vmConfigStoragePathId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineInstancePropertiesStorageProfile;
        });
    }
}

