/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.InstanceViewStatus;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineConfigAgentInstanceView
implements JsonSerializable<VirtualMachineConfigAgentInstanceView> {
    private String vmConfigAgentVersion;
    private List<InstanceViewStatus> statuses;

    private VirtualMachineConfigAgentInstanceView() {
    }

    public String vmConfigAgentVersion() {
        return this.vmConfigAgentVersion;
    }

    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    public void validate() {
        if (this.statuses() != null) {
            this.statuses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vmConfigAgentVersion", this.vmConfigAgentVersion);
        jsonWriter.writeArrayField("statuses", this.statuses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineConfigAgentInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineConfigAgentInstanceView)jsonReader.readObject(reader -> {
            VirtualMachineConfigAgentInstanceView deserializedVirtualMachineConfigAgentInstanceView = new VirtualMachineConfigAgentInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vmConfigAgentVersion".equals(fieldName)) {
                    deserializedVirtualMachineConfigAgentInstanceView.vmConfigAgentVersion = reader.getString();
                    continue;
                }
                if ("statuses".equals(fieldName)) {
                    List statuses;
                    deserializedVirtualMachineConfigAgentInstanceView.statuses = statuses = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineConfigAgentInstanceView;
        });
    }
}

