/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDiskDownloadStatus;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDiskStatusProvisioningStatus;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDiskUploadStatus;
import java.io.IOException;
import java.util.List;

public final class VirtualHardDiskStatus
implements JsonSerializable<VirtualHardDiskStatus> {
    private String errorCode;
    private String errorMessage;
    private VirtualHardDiskStatusProvisioningStatus provisioningStatus;
    private VirtualHardDiskDownloadStatus downloadStatus;
    private VirtualHardDiskUploadStatus uploadStatus;
    private List<String> managedBy;
    private String uniqueId;

    private VirtualHardDiskStatus() {
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public VirtualHardDiskStatusProvisioningStatus provisioningStatus() {
        return this.provisioningStatus;
    }

    public VirtualHardDiskDownloadStatus downloadStatus() {
        return this.downloadStatus;
    }

    public VirtualHardDiskUploadStatus uploadStatus() {
        return this.uploadStatus;
    }

    public List<String> managedBy() {
        return this.managedBy;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public void validate() {
        if (this.provisioningStatus() != null) {
            this.provisioningStatus().validate();
        }
        if (this.downloadStatus() != null) {
            this.downloadStatus().validate();
        }
        if (this.uploadStatus() != null) {
            this.uploadStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("errorCode", this.errorCode);
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        jsonWriter.writeJsonField("provisioningStatus", (JsonSerializable)this.provisioningStatus);
        jsonWriter.writeJsonField("downloadStatus", (JsonSerializable)this.downloadStatus);
        jsonWriter.writeJsonField("uploadStatus", (JsonSerializable)this.uploadStatus);
        jsonWriter.writeArrayField("managedBy", this.managedBy, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("uniqueId", this.uniqueId);
        return jsonWriter.writeEndObject();
    }

    public static VirtualHardDiskStatus fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualHardDiskStatus)jsonReader.readObject(reader -> {
            VirtualHardDiskStatus deserializedVirtualHardDiskStatus = new VirtualHardDiskStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errorCode".equals(fieldName)) {
                    deserializedVirtualHardDiskStatus.errorCode = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedVirtualHardDiskStatus.errorMessage = reader.getString();
                    continue;
                }
                if ("provisioningStatus".equals(fieldName)) {
                    deserializedVirtualHardDiskStatus.provisioningStatus = VirtualHardDiskStatusProvisioningStatus.fromJson(reader);
                    continue;
                }
                if ("downloadStatus".equals(fieldName)) {
                    deserializedVirtualHardDiskStatus.downloadStatus = VirtualHardDiskDownloadStatus.fromJson(reader);
                    continue;
                }
                if ("uploadStatus".equals(fieldName)) {
                    deserializedVirtualHardDiskStatus.uploadStatus = VirtualHardDiskUploadStatus.fromJson(reader);
                    continue;
                }
                if ("managedBy".equals(fieldName)) {
                    List managedBy;
                    deserializedVirtualHardDiskStatus.managedBy = managedBy = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("uniqueId".equals(fieldName)) {
                    deserializedVirtualHardDiskStatus.uniqueId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualHardDiskStatus;
        });
    }
}

