/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.StorageContainerStatusProvisioningStatus;
import java.io.IOException;

public final class StorageContainerStatus
implements JsonSerializable<StorageContainerStatus> {
    private String errorCode;
    private String errorMessage;
    private Long availableSizeMB;
    private Long containerSizeMB;
    private StorageContainerStatusProvisioningStatus provisioningStatus;

    private StorageContainerStatus() {
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Long availableSizeMB() {
        return this.availableSizeMB;
    }

    public Long containerSizeMB() {
        return this.containerSizeMB;
    }

    public StorageContainerStatusProvisioningStatus provisioningStatus() {
        return this.provisioningStatus;
    }

    public void validate() {
        if (this.provisioningStatus() != null) {
            this.provisioningStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("errorCode", this.errorCode);
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        jsonWriter.writeNumberField("availableSizeMB", (Number)this.availableSizeMB);
        jsonWriter.writeNumberField("containerSizeMB", (Number)this.containerSizeMB);
        jsonWriter.writeJsonField("provisioningStatus", (JsonSerializable)this.provisioningStatus);
        return jsonWriter.writeEndObject();
    }

    public static StorageContainerStatus fromJson(JsonReader jsonReader) throws IOException {
        return (StorageContainerStatus)jsonReader.readObject(reader -> {
            StorageContainerStatus deserializedStorageContainerStatus = new StorageContainerStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errorCode".equals(fieldName)) {
                    deserializedStorageContainerStatus.errorCode = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedStorageContainerStatus.errorMessage = reader.getString();
                    continue;
                }
                if ("availableSizeMB".equals(fieldName)) {
                    deserializedStorageContainerStatus.availableSizeMB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("containerSizeMB".equals(fieldName)) {
                    deserializedStorageContainerStatus.containerSizeMB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("provisioningStatus".equals(fieldName)) {
                    deserializedStorageContainerStatus.provisioningStatus = StorageContainerStatusProvisioningStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageContainerStatus;
        });
    }
}

