/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.OsProfileUpdateLinuxConfiguration;
import com.azure.resourcemanager.azurestackhci.vm.models.OsProfileUpdateWindowsConfiguration;
import java.io.IOException;

public final class OsProfileUpdate
implements JsonSerializable<OsProfileUpdate> {
    private String computerName;
    private OsProfileUpdateLinuxConfiguration linuxConfiguration;
    private OsProfileUpdateWindowsConfiguration windowsConfiguration;

    public String computerName() {
        return this.computerName;
    }

    public OsProfileUpdate withComputerName(String computerName) {
        this.computerName = computerName;
        return this;
    }

    public OsProfileUpdateLinuxConfiguration linuxConfiguration() {
        return this.linuxConfiguration;
    }

    public OsProfileUpdate withLinuxConfiguration(OsProfileUpdateLinuxConfiguration linuxConfiguration) {
        this.linuxConfiguration = linuxConfiguration;
        return this;
    }

    public OsProfileUpdateWindowsConfiguration windowsConfiguration() {
        return this.windowsConfiguration;
    }

    public OsProfileUpdate withWindowsConfiguration(OsProfileUpdateWindowsConfiguration windowsConfiguration) {
        this.windowsConfiguration = windowsConfiguration;
        return this;
    }

    public void validate() {
        if (this.linuxConfiguration() != null) {
            this.linuxConfiguration().validate();
        }
        if (this.windowsConfiguration() != null) {
            this.windowsConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("computerName", this.computerName);
        jsonWriter.writeJsonField("linuxConfiguration", (JsonSerializable)this.linuxConfiguration);
        jsonWriter.writeJsonField("windowsConfiguration", (JsonSerializable)this.windowsConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static OsProfileUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (OsProfileUpdate)jsonReader.readObject(reader -> {
            OsProfileUpdate deserializedOsProfileUpdate = new OsProfileUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("computerName".equals(fieldName)) {
                    deserializedOsProfileUpdate.computerName = reader.getString();
                    continue;
                }
                if ("linuxConfiguration".equals(fieldName)) {
                    deserializedOsProfileUpdate.linuxConfiguration = OsProfileUpdateLinuxConfiguration.fromJson(reader);
                    continue;
                }
                if ("windowsConfiguration".equals(fieldName)) {
                    deserializedOsProfileUpdate.windowsConfiguration = OsProfileUpdateWindowsConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOsProfileUpdate;
        });
    }
}

