/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkSecurityGroupStatusProvisioningStatus;
import java.io.IOException;

public final class NetworkSecurityGroupStatus
implements JsonSerializable<NetworkSecurityGroupStatus> {
    private String errorCode;
    private String errorMessage;
    private NetworkSecurityGroupStatusProvisioningStatus provisioningStatus;

    private NetworkSecurityGroupStatus() {
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public NetworkSecurityGroupStatusProvisioningStatus provisioningStatus() {
        return this.provisioningStatus;
    }

    public void validate() {
        if (this.provisioningStatus() != null) {
            this.provisioningStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("errorCode", this.errorCode);
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        jsonWriter.writeJsonField("provisioningStatus", (JsonSerializable)this.provisioningStatus);
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityGroupStatus fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityGroupStatus)jsonReader.readObject(reader -> {
            NetworkSecurityGroupStatus deserializedNetworkSecurityGroupStatus = new NetworkSecurityGroupStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errorCode".equals(fieldName)) {
                    deserializedNetworkSecurityGroupStatus.errorCode = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedNetworkSecurityGroupStatus.errorMessage = reader.getString();
                    continue;
                }
                if ("provisioningStatus".equals(fieldName)) {
                    deserializedNetworkSecurityGroupStatus.provisioningStatus = NetworkSecurityGroupStatusProvisioningStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityGroupStatus;
        });
    }
}

