/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.CloudInitDataSource;
import com.azure.resourcemanager.azurestackhci.vm.models.GalleryImageIdentifier;
import com.azure.resourcemanager.azurestackhci.vm.models.GalleryImageVersion;
import com.azure.resourcemanager.azurestackhci.vm.models.HyperVGeneration;
import com.azure.resourcemanager.azurestackhci.vm.models.MarketplaceGalleryImageStatus;
import com.azure.resourcemanager.azurestackhci.vm.models.OperatingSystemTypes;
import com.azure.resourcemanager.azurestackhci.vm.models.ProvisioningStateEnum;
import java.io.IOException;

public final class MarketplaceGalleryImageProperties
implements JsonSerializable<MarketplaceGalleryImageProperties> {
    private String containerId;
    private OperatingSystemTypes osType;
    private CloudInitDataSource cloudInitDataSource;
    private HyperVGeneration hyperVGeneration;
    private GalleryImageIdentifier identifier;
    private GalleryImageVersion version;
    private ProvisioningStateEnum provisioningState;
    private MarketplaceGalleryImageStatus status;
    private static final ClientLogger LOGGER = new ClientLogger(MarketplaceGalleryImageProperties.class);

    public String containerId() {
        return this.containerId;
    }

    public MarketplaceGalleryImageProperties withContainerId(String containerId) {
        this.containerId = containerId;
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public MarketplaceGalleryImageProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public CloudInitDataSource cloudInitDataSource() {
        return this.cloudInitDataSource;
    }

    public MarketplaceGalleryImageProperties withCloudInitDataSource(CloudInitDataSource cloudInitDataSource) {
        this.cloudInitDataSource = cloudInitDataSource;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public MarketplaceGalleryImageProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public GalleryImageIdentifier identifier() {
        return this.identifier;
    }

    public MarketplaceGalleryImageProperties withIdentifier(GalleryImageIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public GalleryImageVersion version() {
        return this.version;
    }

    public MarketplaceGalleryImageProperties withVersion(GalleryImageVersion version) {
        this.version = version;
        return this;
    }

    public ProvisioningStateEnum provisioningState() {
        return this.provisioningState;
    }

    public MarketplaceGalleryImageStatus status() {
        return this.status;
    }

    public void validate() {
        if (this.osType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osType in model MarketplaceGalleryImageProperties"));
        }
        if (this.identifier() != null) {
            this.identifier().validate();
        }
        if (this.version() != null) {
            this.version().validate();
        }
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("containerId", this.containerId);
        jsonWriter.writeStringField("cloudInitDataSource", this.cloudInitDataSource == null ? null : this.cloudInitDataSource.toString());
        jsonWriter.writeStringField("hyperVGeneration", this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        jsonWriter.writeJsonField("identifier", (JsonSerializable)this.identifier);
        jsonWriter.writeJsonField("version", (JsonSerializable)this.version);
        return jsonWriter.writeEndObject();
    }

    public static MarketplaceGalleryImageProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MarketplaceGalleryImageProperties)jsonReader.readObject(reader -> {
            MarketplaceGalleryImageProperties deserializedMarketplaceGalleryImageProperties = new MarketplaceGalleryImageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("osType".equals(fieldName)) {
                    deserializedMarketplaceGalleryImageProperties.osType = OperatingSystemTypes.fromString(reader.getString());
                    continue;
                }
                if ("containerId".equals(fieldName)) {
                    deserializedMarketplaceGalleryImageProperties.containerId = reader.getString();
                    continue;
                }
                if ("cloudInitDataSource".equals(fieldName)) {
                    deserializedMarketplaceGalleryImageProperties.cloudInitDataSource = CloudInitDataSource.fromString(reader.getString());
                    continue;
                }
                if ("hyperVGeneration".equals(fieldName)) {
                    deserializedMarketplaceGalleryImageProperties.hyperVGeneration = HyperVGeneration.fromString(reader.getString());
                    continue;
                }
                if ("identifier".equals(fieldName)) {
                    deserializedMarketplaceGalleryImageProperties.identifier = GalleryImageIdentifier.fromJson(reader);
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedMarketplaceGalleryImageProperties.version = GalleryImageVersion.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedMarketplaceGalleryImageProperties.provisioningState = ProvisioningStateEnum.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMarketplaceGalleryImageProperties.status = MarketplaceGalleryImageStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMarketplaceGalleryImageProperties;
        });
    }
}

