/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.LogicalNetworkInner;
import com.azure.resourcemanager.azurestackhci.vm.models.ExtendedLocation;
import com.azure.resourcemanager.azurestackhci.vm.models.LogicalNetworkProperties;
import java.util.Map;

public interface LogicalNetwork {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public LogicalNetworkProperties properties();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public LogicalNetworkInner innerModel();

    public Update update();

    public LogicalNetwork refresh();

    public LogicalNetwork refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags {
        public LogicalNetwork apply();

        public LogicalNetwork apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithExtendedLocation {
            public WithCreate withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(LogicalNetworkProperties var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithProperties,
        WithExtendedLocation {
            public LogicalNetwork create();

            public LogicalNetwork create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

