/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.LogicalNetworkArmReference;
import java.io.IOException;

public final class IPConfigurationProperties
implements JsonSerializable<IPConfigurationProperties> {
    private String gateway;
    private String prefixLength;
    private String privateIPAddress;
    private LogicalNetworkArmReference subnet;

    public String gateway() {
        return this.gateway;
    }

    public String prefixLength() {
        return this.prefixLength;
    }

    public String privateIPAddress() {
        return this.privateIPAddress;
    }

    public IPConfigurationProperties withPrivateIPAddress(String privateIPAddress) {
        this.privateIPAddress = privateIPAddress;
        return this;
    }

    public LogicalNetworkArmReference subnet() {
        return this.subnet;
    }

    public IPConfigurationProperties withSubnet(LogicalNetworkArmReference subnet) {
        this.subnet = subnet;
        return this;
    }

    public void validate() {
        if (this.subnet() != null) {
            this.subnet().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateIPAddress", this.privateIPAddress);
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        return jsonWriter.writeEndObject();
    }

    public static IPConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IPConfigurationProperties)jsonReader.readObject(reader -> {
            IPConfigurationProperties deserializedIPConfigurationProperties = new IPConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("gateway".equals(fieldName)) {
                    deserializedIPConfigurationProperties.gateway = reader.getString();
                    continue;
                }
                if ("prefixLength".equals(fieldName)) {
                    deserializedIPConfigurationProperties.prefixLength = reader.getString();
                    continue;
                }
                if ("privateIPAddress".equals(fieldName)) {
                    deserializedIPConfigurationProperties.privateIPAddress = reader.getString();
                    continue;
                }
                if ("subnet".equals(fieldName)) {
                    deserializedIPConfigurationProperties.subnet = LogicalNetworkArmReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIPConfigurationProperties;
        });
    }
}

