/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU;
import com.azure.resourcemanager.azurestackhci.vm.models.VmSizeEnum;
import java.io.IOException;
import java.util.List;

public final class HardwareProfileUpdate
implements JsonSerializable<HardwareProfileUpdate> {
    private VmSizeEnum vmSize;
    private Integer processors;
    private Long memoryMB;
    private List<VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU> virtualMachineGPUs;

    public VmSizeEnum vmSize() {
        return this.vmSize;
    }

    public HardwareProfileUpdate withVmSize(VmSizeEnum vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    public Integer processors() {
        return this.processors;
    }

    public HardwareProfileUpdate withProcessors(Integer processors) {
        this.processors = processors;
        return this;
    }

    public Long memoryMB() {
        return this.memoryMB;
    }

    public HardwareProfileUpdate withMemoryMB(Long memoryMB) {
        this.memoryMB = memoryMB;
        return this;
    }

    public List<VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU> virtualMachineGPUs() {
        return this.virtualMachineGPUs;
    }

    public HardwareProfileUpdate withVirtualMachineGPUs(List<VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU> virtualMachineGPUs) {
        this.virtualMachineGPUs = virtualMachineGPUs;
        return this;
    }

    public void validate() {
        if (this.virtualMachineGPUs() != null) {
            this.virtualMachineGPUs().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vmSize", this.vmSize == null ? null : this.vmSize.toString());
        jsonWriter.writeNumberField("processors", (Number)this.processors);
        jsonWriter.writeNumberField("memoryMB", (Number)this.memoryMB);
        jsonWriter.writeArrayField("virtualMachineGPUs", this.virtualMachineGPUs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static HardwareProfileUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (HardwareProfileUpdate)jsonReader.readObject(reader -> {
            HardwareProfileUpdate deserializedHardwareProfileUpdate = new HardwareProfileUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vmSize".equals(fieldName)) {
                    deserializedHardwareProfileUpdate.vmSize = VmSizeEnum.fromString(reader.getString());
                    continue;
                }
                if ("processors".equals(fieldName)) {
                    deserializedHardwareProfileUpdate.processors = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("memoryMB".equals(fieldName)) {
                    deserializedHardwareProfileUpdate.memoryMB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("virtualMachineGPUs".equals(fieldName)) {
                    List virtualMachineGPUs;
                    deserializedHardwareProfileUpdate.virtualMachineGPUs = virtualMachineGPUs = reader.readArray(reader1 -> VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHardwareProfileUpdate;
        });
    }
}

