/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.GuestCredential;
import com.azure.resourcemanager.azurestackhci.vm.models.ProvisioningAction;
import com.azure.resourcemanager.azurestackhci.vm.models.ProvisioningStateEnum;
import java.io.IOException;

public final class GuestAgentProperties
implements JsonSerializable<GuestAgentProperties> {
    private GuestCredential credentials;
    private ProvisioningAction provisioningAction;
    private String status;
    private ProvisioningStateEnum provisioningState;

    public GuestCredential credentials() {
        return this.credentials;
    }

    public GuestAgentProperties withCredentials(GuestCredential credentials) {
        this.credentials = credentials;
        return this;
    }

    public ProvisioningAction provisioningAction() {
        return this.provisioningAction;
    }

    public GuestAgentProperties withProvisioningAction(ProvisioningAction provisioningAction) {
        this.provisioningAction = provisioningAction;
        return this;
    }

    public String status() {
        return this.status;
    }

    public ProvisioningStateEnum provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.credentials() != null) {
            this.credentials().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("credentials", (JsonSerializable)this.credentials);
        jsonWriter.writeStringField("provisioningAction", this.provisioningAction == null ? null : this.provisioningAction.toString());
        return jsonWriter.writeEndObject();
    }

    public static GuestAgentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GuestAgentProperties)jsonReader.readObject(reader -> {
            GuestAgentProperties deserializedGuestAgentProperties = new GuestAgentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("credentials".equals(fieldName)) {
                    deserializedGuestAgentProperties.credentials = GuestCredential.fromJson(reader);
                    continue;
                }
                if ("provisioningAction".equals(fieldName)) {
                    deserializedGuestAgentProperties.provisioningAction = ProvisioningAction.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedGuestAgentProperties.status = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedGuestAgentProperties.provisioningState = ProvisioningStateEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGuestAgentProperties;
        });
    }
}

