/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.GalleryImageVersionProperties;
import com.azure.resourcemanager.azurestackhci.vm.models.GalleryImageVersionStorageProfile;
import java.io.IOException;

public final class GalleryImageVersion
implements JsonSerializable<GalleryImageVersion> {
    private String name;
    private GalleryImageVersionProperties innerProperties;

    public String name() {
        return this.name;
    }

    public GalleryImageVersion withName(String name) {
        this.name = name;
        return this;
    }

    private GalleryImageVersionProperties innerProperties() {
        return this.innerProperties;
    }

    public GalleryImageVersionStorageProfile storageProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().storageProfile();
    }

    public GalleryImageVersion withStorageProfile(GalleryImageVersionStorageProfile storageProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageVersionProperties();
        }
        this.innerProperties().withStorageProfile(storageProfile);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static GalleryImageVersion fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryImageVersion)jsonReader.readObject(reader -> {
            GalleryImageVersion deserializedGalleryImageVersion = new GalleryImageVersion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedGalleryImageVersion.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedGalleryImageVersion.innerProperties = GalleryImageVersionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryImageVersion;
        });
    }
}

