/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.VirtualMachineInstanceInner;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineInstanceListResult
implements JsonSerializable<VirtualMachineInstanceListResult> {
    private List<VirtualMachineInstanceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineInstanceListResult.class);

    private VirtualMachineInstanceListResult() {
    }

    public List<VirtualMachineInstanceInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model VirtualMachineInstanceListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineInstanceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineInstanceListResult)jsonReader.readObject(reader -> {
            VirtualMachineInstanceListResult deserializedVirtualMachineInstanceListResult = new VirtualMachineInstanceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedVirtualMachineInstanceListResult.value = value = reader.readArray(reader1 -> VirtualMachineInstanceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedVirtualMachineInstanceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineInstanceListResult;
        });
    }
}

