/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.SecurityRuleInner;
import java.io.IOException;
import java.util.List;

public final class SecurityRuleListResult
implements JsonSerializable<SecurityRuleListResult> {
    private List<SecurityRuleInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(SecurityRuleListResult.class);

    private SecurityRuleListResult() {
    }

    public List<SecurityRuleInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SecurityRuleListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static SecurityRuleListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityRuleListResult)jsonReader.readObject(reader -> {
            SecurityRuleListResult deserializedSecurityRuleListResult = new SecurityRuleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSecurityRuleListResult.value = value = reader.readArray(reader1 -> SecurityRuleInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSecurityRuleListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityRuleListResult;
        });
    }
}

