/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.LogicalNetworkInner;
import java.io.IOException;
import java.util.List;

public final class LogicalNetworkListResult
implements JsonSerializable<LogicalNetworkListResult> {
    private List<LogicalNetworkInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(LogicalNetworkListResult.class);

    private LogicalNetworkListResult() {
    }

    public List<LogicalNetworkInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model LogicalNetworkListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static LogicalNetworkListResult fromJson(JsonReader jsonReader) throws IOException {
        return (LogicalNetworkListResult)jsonReader.readObject(reader -> {
            LogicalNetworkListResult deserializedLogicalNetworkListResult = new LogicalNetworkListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedLogicalNetworkListResult.value = value = reader.readArray(reader1 -> LogicalNetworkInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedLogicalNetworkListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogicalNetworkListResult;
        });
    }
}

