/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.HybridIdentityMetadataInner;
import java.io.IOException;
import java.util.List;

public final class HybridIdentityMetadataListResult
implements JsonSerializable<HybridIdentityMetadataListResult> {
    private List<HybridIdentityMetadataInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(HybridIdentityMetadataListResult.class);

    private HybridIdentityMetadataListResult() {
    }

    public List<HybridIdentityMetadataInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model HybridIdentityMetadataListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static HybridIdentityMetadataListResult fromJson(JsonReader jsonReader) throws IOException {
        return (HybridIdentityMetadataListResult)jsonReader.readObject(reader -> {
            HybridIdentityMetadataListResult deserializedHybridIdentityMetadataListResult = new HybridIdentityMetadataListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedHybridIdentityMetadataListResult.value = value = reader.readArray(reader1 -> HybridIdentityMetadataInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedHybridIdentityMetadataListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHybridIdentityMetadataListResult;
        });
    }
}

