/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.GalleryImageInner;
import java.io.IOException;
import java.util.List;

public final class GalleryImageListResult
implements JsonSerializable<GalleryImageListResult> {
    private List<GalleryImageInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryImageListResult.class);

    private GalleryImageListResult() {
    }

    public List<GalleryImageInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model GalleryImageListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static GalleryImageListResult fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryImageListResult)jsonReader.readObject(reader -> {
            GalleryImageListResult deserializedGalleryImageListResult = new GalleryImageListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedGalleryImageListResult.value = value = reader.readArray(reader1 -> GalleryImageInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedGalleryImageListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryImageListResult;
        });
    }
}

