/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.VirtualHardDisksClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.VirtualHardDiskInner;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.VirtualHardDiskUploadResponseInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.implementation.VirtualHardDiskImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.VirtualHardDiskUploadResponseImpl;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDisk;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDiskUploadRequest;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDiskUploadResponse;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDisks;

public final class VirtualHardDisksImpl
implements VirtualHardDisks {
    private static final ClientLogger LOGGER = new ClientLogger(VirtualHardDisksImpl.class);
    private final VirtualHardDisksClient innerClient;
    private final AzureStackHciVmManager serviceManager;

    public VirtualHardDisksImpl(VirtualHardDisksClient innerClient, AzureStackHciVmManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<VirtualHardDisk> getByResourceGroupWithResponse(String resourceGroupName, String virtualHardDiskName, Context context) {
        Response<VirtualHardDiskInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, virtualHardDiskName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VirtualHardDiskImpl((VirtualHardDiskInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public VirtualHardDisk getByResourceGroup(String resourceGroupName, String virtualHardDiskName) {
        VirtualHardDiskInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, virtualHardDiskName);
        if (inner != null) {
            return new VirtualHardDiskImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String virtualHardDiskName) {
        this.serviceClient().delete(resourceGroupName, virtualHardDiskName);
    }

    @Override
    public void delete(String resourceGroupName, String virtualHardDiskName, Context context) {
        this.serviceClient().delete(resourceGroupName, virtualHardDiskName, context);
    }

    @Override
    public PagedIterable<VirtualHardDisk> listByResourceGroup(String resourceGroupName) {
        PagedIterable<VirtualHardDiskInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualHardDiskImpl((VirtualHardDiskInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<VirtualHardDisk> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<VirtualHardDiskInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualHardDiskImpl((VirtualHardDiskInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<VirtualHardDisk> list() {
        PagedIterable<VirtualHardDiskInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualHardDiskImpl((VirtualHardDiskInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<VirtualHardDisk> list(Context context) {
        PagedIterable<VirtualHardDiskInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualHardDiskImpl((VirtualHardDiskInner)((Object)inner1), this.manager()));
    }

    @Override
    public VirtualHardDiskUploadResponse upload(String resourceGroupName, String virtualHardDiskName, VirtualHardDiskUploadRequest body) {
        VirtualHardDiskUploadResponseInner inner = this.serviceClient().upload(resourceGroupName, virtualHardDiskName, body);
        if (inner != null) {
            return new VirtualHardDiskUploadResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public VirtualHardDiskUploadResponse upload(String resourceGroupName, String virtualHardDiskName, VirtualHardDiskUploadRequest body, Context context) {
        VirtualHardDiskUploadResponseInner inner = this.serviceClient().upload(resourceGroupName, virtualHardDiskName, body, context);
        if (inner != null) {
            return new VirtualHardDiskUploadResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public VirtualHardDisk getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String virtualHardDiskName = ResourceManagerUtils.getValueFromIdByName(id, "virtualHardDisks");
        if (virtualHardDiskName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualHardDisks'.", id)));
        }
        return (VirtualHardDisk)this.getByResourceGroupWithResponse(resourceGroupName, virtualHardDiskName, Context.NONE).getValue();
    }

    @Override
    public Response<VirtualHardDisk> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String virtualHardDiskName = ResourceManagerUtils.getValueFromIdByName(id, "virtualHardDisks");
        if (virtualHardDiskName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualHardDisks'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, virtualHardDiskName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String virtualHardDiskName = ResourceManagerUtils.getValueFromIdByName(id, "virtualHardDisks");
        if (virtualHardDiskName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualHardDisks'.", id)));
        }
        this.delete(resourceGroupName, virtualHardDiskName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String virtualHardDiskName = ResourceManagerUtils.getValueFromIdByName(id, "virtualHardDisks");
        if (virtualHardDiskName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualHardDisks'.", id)));
        }
        this.delete(resourceGroupName, virtualHardDiskName, context);
    }

    private VirtualHardDisksClient serviceClient() {
        return this.innerClient;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public VirtualHardDiskImpl define(String name) {
        return new VirtualHardDiskImpl(name, this.manager());
    }
}

