/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.StorageContainersClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.StorageContainerInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.implementation.StorageContainerImpl;
import com.azure.resourcemanager.azurestackhci.vm.models.StorageContainer;
import com.azure.resourcemanager.azurestackhci.vm.models.StorageContainers;

public final class StorageContainersImpl
implements StorageContainers {
    private static final ClientLogger LOGGER = new ClientLogger(StorageContainersImpl.class);
    private final StorageContainersClient innerClient;
    private final AzureStackHciVmManager serviceManager;

    public StorageContainersImpl(StorageContainersClient innerClient, AzureStackHciVmManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<StorageContainer> getByResourceGroupWithResponse(String resourceGroupName, String storageContainerName, Context context) {
        Response<StorageContainerInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, storageContainerName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new StorageContainerImpl((StorageContainerInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public StorageContainer getByResourceGroup(String resourceGroupName, String storageContainerName) {
        StorageContainerInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, storageContainerName);
        if (inner != null) {
            return new StorageContainerImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String storageContainerName) {
        this.serviceClient().delete(resourceGroupName, storageContainerName);
    }

    @Override
    public void delete(String resourceGroupName, String storageContainerName, Context context) {
        this.serviceClient().delete(resourceGroupName, storageContainerName, context);
    }

    @Override
    public PagedIterable<StorageContainer> listByResourceGroup(String resourceGroupName) {
        PagedIterable<StorageContainerInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageContainerImpl((StorageContainerInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<StorageContainer> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<StorageContainerInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageContainerImpl((StorageContainerInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<StorageContainer> list() {
        PagedIterable<StorageContainerInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageContainerImpl((StorageContainerInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<StorageContainer> list(Context context) {
        PagedIterable<StorageContainerInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageContainerImpl((StorageContainerInner)((Object)inner1), this.manager()));
    }

    @Override
    public StorageContainer getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storageContainerName = ResourceManagerUtils.getValueFromIdByName(id, "storageContainers");
        if (storageContainerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageContainers'.", id)));
        }
        return (StorageContainer)this.getByResourceGroupWithResponse(resourceGroupName, storageContainerName, Context.NONE).getValue();
    }

    @Override
    public Response<StorageContainer> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storageContainerName = ResourceManagerUtils.getValueFromIdByName(id, "storageContainers");
        if (storageContainerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageContainers'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, storageContainerName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storageContainerName = ResourceManagerUtils.getValueFromIdByName(id, "storageContainers");
        if (storageContainerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageContainers'.", id)));
        }
        this.delete(resourceGroupName, storageContainerName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storageContainerName = ResourceManagerUtils.getValueFromIdByName(id, "storageContainers");
        if (storageContainerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageContainers'.", id)));
        }
        this.delete(resourceGroupName, storageContainerName, context);
    }

    private StorageContainersClient serviceClient() {
        return this.innerClient;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public StorageContainerImpl define(String name) {
        return new StorageContainerImpl(name, this.manager());
    }
}

