/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.StorageContainerInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.models.ExtendedLocation;
import com.azure.resourcemanager.azurestackhci.vm.models.StorageContainer;
import com.azure.resourcemanager.azurestackhci.vm.models.StorageContainerProperties;
import com.azure.resourcemanager.azurestackhci.vm.models.StorageContainerTagsUpdate;
import java.util.Collections;
import java.util.Map;

public final class StorageContainerImpl
implements StorageContainer,
StorageContainer.Definition,
StorageContainer.Update {
    private StorageContainerInner innerObject;
    private final AzureStackHciVmManager serviceManager;
    private String resourceGroupName;
    private String storageContainerName;
    private StorageContainerTagsUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public StorageContainerProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public StorageContainerInner innerModel() {
        return this.innerObject;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public StorageContainerImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public StorageContainer create() {
        this.innerObject = this.serviceManager.serviceClient().getStorageContainers().createOrUpdate(this.resourceGroupName, this.storageContainerName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public StorageContainer create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getStorageContainers().createOrUpdate(this.resourceGroupName, this.storageContainerName, this.innerModel(), context);
        return this;
    }

    StorageContainerImpl(String name, AzureStackHciVmManager serviceManager) {
        this.innerObject = new StorageContainerInner();
        this.serviceManager = serviceManager;
        this.storageContainerName = name;
    }

    @Override
    public StorageContainerImpl update() {
        this.updateProperties = new StorageContainerTagsUpdate();
        return this;
    }

    @Override
    public StorageContainer apply() {
        this.innerObject = this.serviceManager.serviceClient().getStorageContainers().update(this.resourceGroupName, this.storageContainerName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public StorageContainer apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getStorageContainers().update(this.resourceGroupName, this.storageContainerName, this.updateProperties, context);
        return this;
    }

    StorageContainerImpl(StorageContainerInner innerObject, AzureStackHciVmManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.storageContainerName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "storageContainers");
    }

    @Override
    public StorageContainer refresh() {
        this.innerObject = (StorageContainerInner)((Object)this.serviceManager.serviceClient().getStorageContainers().getByResourceGroupWithResponse(this.resourceGroupName, this.storageContainerName, Context.NONE).getValue());
        return this;
    }

    @Override
    public StorageContainer refresh(Context context) {
        this.innerObject = (StorageContainerInner)((Object)this.serviceManager.serviceClient().getStorageContainers().getByResourceGroupWithResponse(this.resourceGroupName, this.storageContainerName, context).getValue());
        return this;
    }

    @Override
    public StorageContainerImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public StorageContainerImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public StorageContainerImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public StorageContainerImpl withProperties(StorageContainerProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public StorageContainerImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

