/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.NetworkInterfacesClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.NetworkInterfaceImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkInterface;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkInterfaces;

public final class NetworkInterfacesImpl
implements NetworkInterfaces {
    private static final ClientLogger LOGGER = new ClientLogger(NetworkInterfacesImpl.class);
    private final NetworkInterfacesClient innerClient;
    private final AzureStackHciVmManager serviceManager;

    public NetworkInterfacesImpl(NetworkInterfacesClient innerClient, AzureStackHciVmManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<NetworkInterface> getByResourceGroupWithResponse(String resourceGroupName, String networkInterfaceName, Context context) {
        Response<NetworkInterfaceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, networkInterfaceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NetworkInterfaceImpl((NetworkInterfaceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public NetworkInterface getByResourceGroup(String resourceGroupName, String networkInterfaceName) {
        NetworkInterfaceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, networkInterfaceName);
        if (inner != null) {
            return new NetworkInterfaceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String networkInterfaceName) {
        this.serviceClient().delete(resourceGroupName, networkInterfaceName);
    }

    @Override
    public void delete(String resourceGroupName, String networkInterfaceName, Context context) {
        this.serviceClient().delete(resourceGroupName, networkInterfaceName, context);
    }

    @Override
    public PagedIterable<NetworkInterface> listByResourceGroup(String resourceGroupName) {
        PagedIterable<NetworkInterfaceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetworkInterfaceImpl((NetworkInterfaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NetworkInterface> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<NetworkInterfaceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetworkInterfaceImpl((NetworkInterfaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NetworkInterface> list() {
        PagedIterable<NetworkInterfaceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetworkInterfaceImpl((NetworkInterfaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NetworkInterface> list(Context context) {
        PagedIterable<NetworkInterfaceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetworkInterfaceImpl((NetworkInterfaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public NetworkInterface getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String networkInterfaceName = ResourceManagerUtils.getValueFromIdByName(id, "networkInterfaces");
        if (networkInterfaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'networkInterfaces'.", id)));
        }
        return (NetworkInterface)this.getByResourceGroupWithResponse(resourceGroupName, networkInterfaceName, Context.NONE).getValue();
    }

    @Override
    public Response<NetworkInterface> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String networkInterfaceName = ResourceManagerUtils.getValueFromIdByName(id, "networkInterfaces");
        if (networkInterfaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'networkInterfaces'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, networkInterfaceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String networkInterfaceName = ResourceManagerUtils.getValueFromIdByName(id, "networkInterfaces");
        if (networkInterfaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'networkInterfaces'.", id)));
        }
        this.delete(resourceGroupName, networkInterfaceName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String networkInterfaceName = ResourceManagerUtils.getValueFromIdByName(id, "networkInterfaces");
        if (networkInterfaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'networkInterfaces'.", id)));
        }
        this.delete(resourceGroupName, networkInterfaceName, context);
    }

    private NetworkInterfacesClient serviceClient() {
        return this.innerClient;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public NetworkInterfaceImpl define(String name) {
        return new NetworkInterfaceImpl(name, this.manager());
    }
}

