/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.MarketplaceGalleryImagesClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.MarketplaceGalleryImageInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.MarketplaceGalleryImageImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.models.MarketplaceGalleryImage;
import com.azure.resourcemanager.azurestackhci.vm.models.MarketplaceGalleryImages;

public final class MarketplaceGalleryImagesImpl
implements MarketplaceGalleryImages {
    private static final ClientLogger LOGGER = new ClientLogger(MarketplaceGalleryImagesImpl.class);
    private final MarketplaceGalleryImagesClient innerClient;
    private final AzureStackHciVmManager serviceManager;

    public MarketplaceGalleryImagesImpl(MarketplaceGalleryImagesClient innerClient, AzureStackHciVmManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<MarketplaceGalleryImage> getByResourceGroupWithResponse(String resourceGroupName, String marketplaceGalleryImageName, Context context) {
        Response<MarketplaceGalleryImageInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, marketplaceGalleryImageName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new MarketplaceGalleryImageImpl((MarketplaceGalleryImageInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public MarketplaceGalleryImage getByResourceGroup(String resourceGroupName, String marketplaceGalleryImageName) {
        MarketplaceGalleryImageInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, marketplaceGalleryImageName);
        if (inner != null) {
            return new MarketplaceGalleryImageImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String marketplaceGalleryImageName) {
        this.serviceClient().delete(resourceGroupName, marketplaceGalleryImageName);
    }

    @Override
    public void delete(String resourceGroupName, String marketplaceGalleryImageName, Context context) {
        this.serviceClient().delete(resourceGroupName, marketplaceGalleryImageName, context);
    }

    @Override
    public PagedIterable<MarketplaceGalleryImage> listByResourceGroup(String resourceGroupName) {
        PagedIterable<MarketplaceGalleryImageInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MarketplaceGalleryImageImpl((MarketplaceGalleryImageInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<MarketplaceGalleryImage> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<MarketplaceGalleryImageInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MarketplaceGalleryImageImpl((MarketplaceGalleryImageInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<MarketplaceGalleryImage> list() {
        PagedIterable<MarketplaceGalleryImageInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MarketplaceGalleryImageImpl((MarketplaceGalleryImageInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<MarketplaceGalleryImage> list(Context context) {
        PagedIterable<MarketplaceGalleryImageInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MarketplaceGalleryImageImpl((MarketplaceGalleryImageInner)((Object)inner1), this.manager()));
    }

    @Override
    public MarketplaceGalleryImage getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String marketplaceGalleryImageName = ResourceManagerUtils.getValueFromIdByName(id, "marketplaceGalleryImages");
        if (marketplaceGalleryImageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'marketplaceGalleryImages'.", id)));
        }
        return (MarketplaceGalleryImage)this.getByResourceGroupWithResponse(resourceGroupName, marketplaceGalleryImageName, Context.NONE).getValue();
    }

    @Override
    public Response<MarketplaceGalleryImage> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String marketplaceGalleryImageName = ResourceManagerUtils.getValueFromIdByName(id, "marketplaceGalleryImages");
        if (marketplaceGalleryImageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'marketplaceGalleryImages'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, marketplaceGalleryImageName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String marketplaceGalleryImageName = ResourceManagerUtils.getValueFromIdByName(id, "marketplaceGalleryImages");
        if (marketplaceGalleryImageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'marketplaceGalleryImages'.", id)));
        }
        this.delete(resourceGroupName, marketplaceGalleryImageName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String marketplaceGalleryImageName = ResourceManagerUtils.getValueFromIdByName(id, "marketplaceGalleryImages");
        if (marketplaceGalleryImageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'marketplaceGalleryImages'.", id)));
        }
        this.delete(resourceGroupName, marketplaceGalleryImageName, context);
    }

    private MarketplaceGalleryImagesClient serviceClient() {
        return this.innerClient;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public MarketplaceGalleryImageImpl define(String name) {
        return new MarketplaceGalleryImageImpl(name, this.manager());
    }
}

