/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.MarketplaceGalleryImageInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.models.ExtendedLocation;
import com.azure.resourcemanager.azurestackhci.vm.models.MarketplaceGalleryImage;
import com.azure.resourcemanager.azurestackhci.vm.models.MarketplaceGalleryImageProperties;
import com.azure.resourcemanager.azurestackhci.vm.models.MarketplaceGalleryImageTagsUpdate;
import java.util.Collections;
import java.util.Map;

public final class MarketplaceGalleryImageImpl
implements MarketplaceGalleryImage,
MarketplaceGalleryImage.Definition,
MarketplaceGalleryImage.Update {
    private MarketplaceGalleryImageInner innerObject;
    private final AzureStackHciVmManager serviceManager;
    private String resourceGroupName;
    private String marketplaceGalleryImageName;
    private MarketplaceGalleryImageTagsUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public MarketplaceGalleryImageProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public MarketplaceGalleryImageInner innerModel() {
        return this.innerObject;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public MarketplaceGalleryImageImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public MarketplaceGalleryImage create() {
        this.innerObject = this.serviceManager.serviceClient().getMarketplaceGalleryImages().createOrUpdate(this.resourceGroupName, this.marketplaceGalleryImageName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public MarketplaceGalleryImage create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getMarketplaceGalleryImages().createOrUpdate(this.resourceGroupName, this.marketplaceGalleryImageName, this.innerModel(), context);
        return this;
    }

    MarketplaceGalleryImageImpl(String name, AzureStackHciVmManager serviceManager) {
        this.innerObject = new MarketplaceGalleryImageInner();
        this.serviceManager = serviceManager;
        this.marketplaceGalleryImageName = name;
    }

    @Override
    public MarketplaceGalleryImageImpl update() {
        this.updateProperties = new MarketplaceGalleryImageTagsUpdate();
        return this;
    }

    @Override
    public MarketplaceGalleryImage apply() {
        this.innerObject = this.serviceManager.serviceClient().getMarketplaceGalleryImages().update(this.resourceGroupName, this.marketplaceGalleryImageName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public MarketplaceGalleryImage apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getMarketplaceGalleryImages().update(this.resourceGroupName, this.marketplaceGalleryImageName, this.updateProperties, context);
        return this;
    }

    MarketplaceGalleryImageImpl(MarketplaceGalleryImageInner innerObject, AzureStackHciVmManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.marketplaceGalleryImageName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "marketplaceGalleryImages");
    }

    @Override
    public MarketplaceGalleryImage refresh() {
        this.innerObject = (MarketplaceGalleryImageInner)((Object)this.serviceManager.serviceClient().getMarketplaceGalleryImages().getByResourceGroupWithResponse(this.resourceGroupName, this.marketplaceGalleryImageName, Context.NONE).getValue());
        return this;
    }

    @Override
    public MarketplaceGalleryImage refresh(Context context) {
        this.innerObject = (MarketplaceGalleryImageInner)((Object)this.serviceManager.serviceClient().getMarketplaceGalleryImages().getByResourceGroupWithResponse(this.resourceGroupName, this.marketplaceGalleryImageName, context).getValue());
        return this;
    }

    @Override
    public MarketplaceGalleryImageImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public MarketplaceGalleryImageImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public MarketplaceGalleryImageImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public MarketplaceGalleryImageImpl withProperties(MarketplaceGalleryImageProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public MarketplaceGalleryImageImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

