/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.LogicalNetworksClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.LogicalNetworkInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.LogicalNetworkImpl;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.models.LogicalNetwork;
import com.azure.resourcemanager.azurestackhci.vm.models.LogicalNetworks;

public final class LogicalNetworksImpl
implements LogicalNetworks {
    private static final ClientLogger LOGGER = new ClientLogger(LogicalNetworksImpl.class);
    private final LogicalNetworksClient innerClient;
    private final AzureStackHciVmManager serviceManager;

    public LogicalNetworksImpl(LogicalNetworksClient innerClient, AzureStackHciVmManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<LogicalNetwork> getByResourceGroupWithResponse(String resourceGroupName, String logicalNetworkName, Context context) {
        Response<LogicalNetworkInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, logicalNetworkName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LogicalNetworkImpl((LogicalNetworkInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public LogicalNetwork getByResourceGroup(String resourceGroupName, String logicalNetworkName) {
        LogicalNetworkInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, logicalNetworkName);
        if (inner != null) {
            return new LogicalNetworkImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String logicalNetworkName) {
        this.serviceClient().delete(resourceGroupName, logicalNetworkName);
    }

    @Override
    public void delete(String resourceGroupName, String logicalNetworkName, Context context) {
        this.serviceClient().delete(resourceGroupName, logicalNetworkName, context);
    }

    @Override
    public PagedIterable<LogicalNetwork> listByResourceGroup(String resourceGroupName) {
        PagedIterable<LogicalNetworkInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new LogicalNetworkImpl((LogicalNetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<LogicalNetwork> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<LogicalNetworkInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new LogicalNetworkImpl((LogicalNetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<LogicalNetwork> list() {
        PagedIterable<LogicalNetworkInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new LogicalNetworkImpl((LogicalNetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<LogicalNetwork> list(Context context) {
        PagedIterable<LogicalNetworkInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new LogicalNetworkImpl((LogicalNetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public LogicalNetwork getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String logicalNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "logicalNetworks");
        if (logicalNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'logicalNetworks'.", id)));
        }
        return (LogicalNetwork)this.getByResourceGroupWithResponse(resourceGroupName, logicalNetworkName, Context.NONE).getValue();
    }

    @Override
    public Response<LogicalNetwork> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String logicalNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "logicalNetworks");
        if (logicalNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'logicalNetworks'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, logicalNetworkName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String logicalNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "logicalNetworks");
        if (logicalNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'logicalNetworks'.", id)));
        }
        this.delete(resourceGroupName, logicalNetworkName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String logicalNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "logicalNetworks");
        if (logicalNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'logicalNetworks'.", id)));
        }
        this.delete(resourceGroupName, logicalNetworkName, context);
    }

    private LogicalNetworksClient serviceClient() {
        return this.innerClient;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public LogicalNetworkImpl define(String name) {
        return new LogicalNetworkImpl(name, this.manager());
    }
}

