/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.ExtendedLocation;
import com.azure.resourcemanager.azurestackhci.vm.models.ManagedServiceIdentity;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstanceProperties;
import java.io.IOException;

public final class VirtualMachineInstanceInner
extends ProxyResource {
    private VirtualMachineInstanceProperties properties;
    private ExtendedLocation extendedLocation;
    private ManagedServiceIdentity identity;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public VirtualMachineInstanceProperties properties() {
        return this.properties;
    }

    public VirtualMachineInstanceInner withProperties(VirtualMachineInstanceProperties properties) {
        this.properties = properties;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public VirtualMachineInstanceInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public VirtualMachineInstanceInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineInstanceInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineInstanceInner)((Object)jsonReader.readObject(reader -> {
            VirtualMachineInstanceInner deserializedVirtualMachineInstanceInner = new VirtualMachineInstanceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVirtualMachineInstanceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineInstanceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualMachineInstanceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualMachineInstanceInner.properties = VirtualMachineInstanceProperties.fromJson(reader);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedVirtualMachineInstanceInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedVirtualMachineInstanceInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedVirtualMachineInstanceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineInstanceInner;
        }));
    }
}

