/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.ExtendedLocation;
import com.azure.resourcemanager.azurestackhci.vm.models.GalleryImageProperties;
import java.io.IOException;
import java.util.Map;

public final class GalleryImageInner
extends Resource {
    private GalleryImageProperties properties;
    private ExtendedLocation extendedLocation;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public GalleryImageProperties properties() {
        return this.properties;
    }

    public GalleryImageInner withProperties(GalleryImageProperties properties) {
        this.properties = properties;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public GalleryImageInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public GalleryImageInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public GalleryImageInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        return jsonWriter.writeEndObject();
    }

    public static GalleryImageInner fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryImageInner)((Object)jsonReader.readObject(reader -> {
            GalleryImageInner deserializedGalleryImageInner = new GalleryImageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGalleryImageInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGalleryImageInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGalleryImageInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedGalleryImageInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGalleryImageInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedGalleryImageInner.properties = GalleryImageProperties.fromJson(reader);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedGalleryImageInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedGalleryImageInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryImageInner;
        }));
    }
}

