/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphBaseItemInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDriveItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphItemReference;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphList;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphQuota;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSharepointIds;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphUserInner;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphDrive
extends MicrosoftGraphBaseItemInner {
    private String driveType;
    private MicrosoftGraphIdentitySet owner;
    private MicrosoftGraphQuota quota;
    private MicrosoftGraphSharepointIds sharePointIds;
    private Map<String, Object> system;
    private List<MicrosoftGraphDriveItem> following;
    private List<MicrosoftGraphDriveItem> items;
    private MicrosoftGraphList list;
    private MicrosoftGraphDriveItem root;
    private List<MicrosoftGraphDriveItem> special;
    private Map<String, Object> additionalProperties;

    public String driveType() {
        return this.driveType;
    }

    public MicrosoftGraphDrive withDriveType(String driveType) {
        this.driveType = driveType;
        return this;
    }

    public MicrosoftGraphIdentitySet owner() {
        return this.owner;
    }

    public MicrosoftGraphDrive withOwner(MicrosoftGraphIdentitySet owner) {
        this.owner = owner;
        return this;
    }

    public MicrosoftGraphQuota quota() {
        return this.quota;
    }

    public MicrosoftGraphDrive withQuota(MicrosoftGraphQuota quota) {
        this.quota = quota;
        return this;
    }

    public MicrosoftGraphSharepointIds sharePointIds() {
        return this.sharePointIds;
    }

    public MicrosoftGraphDrive withSharePointIds(MicrosoftGraphSharepointIds sharePointIds) {
        this.sharePointIds = sharePointIds;
        return this;
    }

    public Map<String, Object> system() {
        return this.system;
    }

    public MicrosoftGraphDrive withSystem(Map<String, Object> system) {
        this.system = system;
        return this;
    }

    public List<MicrosoftGraphDriveItem> following() {
        return this.following;
    }

    public MicrosoftGraphDrive withFollowing(List<MicrosoftGraphDriveItem> following) {
        this.following = following;
        return this;
    }

    public List<MicrosoftGraphDriveItem> items() {
        return this.items;
    }

    public MicrosoftGraphDrive withItems(List<MicrosoftGraphDriveItem> items) {
        this.items = items;
        return this;
    }

    public MicrosoftGraphList list() {
        return this.list;
    }

    public MicrosoftGraphDrive withList(MicrosoftGraphList list) {
        this.list = list;
        return this;
    }

    public MicrosoftGraphDriveItem root() {
        return this.root;
    }

    public MicrosoftGraphDrive withRoot(MicrosoftGraphDriveItem root) {
        this.root = root;
        return this;
    }

    public List<MicrosoftGraphDriveItem> special() {
        return this.special;
    }

    public MicrosoftGraphDrive withSpecial(List<MicrosoftGraphDriveItem> special) {
        this.special = special;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphDrive withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphDrive withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        super.withCreatedBy(createdBy);
        return this;
    }

    @Override
    public MicrosoftGraphDrive withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphDrive withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public MicrosoftGraphDrive withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    @Override
    public MicrosoftGraphDrive withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    @Override
    public MicrosoftGraphDrive withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphDrive withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public MicrosoftGraphDrive withParentReference(MicrosoftGraphItemReference parentReference) {
        super.withParentReference(parentReference);
        return this;
    }

    @Override
    public MicrosoftGraphDrive withWebUrl(String webUrl) {
        super.withWebUrl(webUrl);
        return this;
    }

    @Override
    public MicrosoftGraphDrive withCreatedByUser(MicrosoftGraphUserInner createdByUser) {
        super.withCreatedByUser(createdByUser);
        return this;
    }

    @Override
    public MicrosoftGraphDrive withLastModifiedByUser(MicrosoftGraphUserInner lastModifiedByUser) {
        super.withLastModifiedByUser(lastModifiedByUser);
        return this;
    }

    @Override
    public MicrosoftGraphDrive withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.owner() != null) {
            this.owner().validate();
        }
        if (this.quota() != null) {
            this.quota().validate();
        }
        if (this.sharePointIds() != null) {
            this.sharePointIds().validate();
        }
        if (this.following() != null) {
            this.following().forEach(e -> e.validate());
        }
        if (this.items() != null) {
            this.items().forEach(e -> e.validate());
        }
        if (this.list() != null) {
            this.list().validate();
        }
        if (this.root() != null) {
            this.root().validate();
        }
        if (this.special() != null) {
            this.special().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("createdBy", (JsonSerializable)this.createdBy());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("eTag", this.etag());
        jsonWriter.writeJsonField("lastModifiedBy", (JsonSerializable)this.lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeJsonField("parentReference", (JsonSerializable)this.parentReference());
        jsonWriter.writeStringField("webUrl", this.webUrl());
        jsonWriter.writeJsonField("createdByUser", (JsonSerializable)this.createdByUser());
        jsonWriter.writeJsonField("lastModifiedByUser", (JsonSerializable)this.lastModifiedByUser());
        jsonWriter.writeStringField("driveType", this.driveType);
        jsonWriter.writeJsonField("owner", (JsonSerializable)this.owner);
        jsonWriter.writeJsonField("quota", (JsonSerializable)this.quota);
        jsonWriter.writeJsonField("sharePointIds", (JsonSerializable)this.sharePointIds);
        jsonWriter.writeMapField("system", this.system, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("following", this.following, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("items", this.items, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("list", (JsonSerializable)this.list);
        jsonWriter.writeJsonField("root", (JsonSerializable)this.root);
        jsonWriter.writeArrayField("special", this.special, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphDrive fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphDrive)jsonReader.readObject(reader -> {
            MicrosoftGraphDrive deserializedMicrosoftGraphDrive = new MicrosoftGraphDrive();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withId(reader.getString());
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withCreatedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withDescription(reader.getString());
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withEtag(reader.getString());
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withLastModifiedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withName(reader.getString());
                    continue;
                }
                if ("parentReference".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withParentReference(MicrosoftGraphItemReference.fromJson(reader));
                    continue;
                }
                if ("webUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withWebUrl(reader.getString());
                    continue;
                }
                if ("createdByUser".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withCreatedByUser(MicrosoftGraphUserInner.fromJson(reader));
                    continue;
                }
                if ("lastModifiedByUser".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withLastModifiedByUser(MicrosoftGraphUserInner.fromJson(reader));
                    continue;
                }
                if ("driveType".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.driveType = reader.getString();
                    continue;
                }
                if ("owner".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.owner = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("quota".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.quota = MicrosoftGraphQuota.fromJson(reader);
                    continue;
                }
                if ("sharePointIds".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.sharePointIds = MicrosoftGraphSharepointIds.fromJson(reader);
                    continue;
                }
                if ("system".equals(fieldName)) {
                    Map system;
                    deserializedMicrosoftGraphDrive.system = system = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("following".equals(fieldName)) {
                    List following;
                    deserializedMicrosoftGraphDrive.following = following = reader.readArray(reader1 -> MicrosoftGraphDriveItem.fromJson(reader1));
                    continue;
                }
                if ("items".equals(fieldName)) {
                    List items;
                    deserializedMicrosoftGraphDrive.items = items = reader.readArray(reader1 -> MicrosoftGraphDriveItem.fromJson(reader1));
                    continue;
                }
                if ("list".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.list = MicrosoftGraphList.fromJson(reader);
                    continue;
                }
                if ("root".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.root = MicrosoftGraphDriveItem.fromJson(reader);
                    continue;
                }
                if ("special".equals(fieldName)) {
                    List special;
                    deserializedMicrosoftGraphDrive.special = special = reader.readArray(reader1 -> MicrosoftGraphDriveItem.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphDrive.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphDrive;
        });
    }
}

