/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScopedRoleMembership;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphDirectoryRole
extends MicrosoftGraphDirectoryObjectInner {
    private String description;
    private String displayName;
    private String roleTemplateId;
    private List<MicrosoftGraphDirectoryObjectInner> members;
    private List<MicrosoftGraphScopedRoleMembership> scopedMembers;
    private Map<String, Object> additionalProperties;

    public String description() {
        return this.description;
    }

    public MicrosoftGraphDirectoryRole withDescription(String description) {
        this.description = description;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphDirectoryRole withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String roleTemplateId() {
        return this.roleTemplateId;
    }

    public MicrosoftGraphDirectoryRole withRoleTemplateId(String roleTemplateId) {
        this.roleTemplateId = roleTemplateId;
        return this;
    }

    public List<MicrosoftGraphDirectoryObjectInner> members() {
        return this.members;
    }

    public MicrosoftGraphDirectoryRole withMembers(List<MicrosoftGraphDirectoryObjectInner> members) {
        this.members = members;
        return this;
    }

    public List<MicrosoftGraphScopedRoleMembership> scopedMembers() {
        return this.scopedMembers;
    }

    public MicrosoftGraphDirectoryRole withScopedMembers(List<MicrosoftGraphScopedRoleMembership> scopedMembers) {
        this.scopedMembers = scopedMembers;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphDirectoryRole withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphDirectoryRole withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphDirectoryRole withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.members() != null) {
            this.members().forEach(e -> e.validate());
        }
        if (this.scopedMembers() != null) {
            this.scopedMembers().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("deletedDateTime", this.deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletedDateTime()));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("roleTemplateId", this.roleTemplateId);
        jsonWriter.writeArrayField("members", this.members, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("scopedMembers", this.scopedMembers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphDirectoryRole fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphDirectoryRole)jsonReader.readObject(reader -> {
            MicrosoftGraphDirectoryRole deserializedMicrosoftGraphDirectoryRole = new MicrosoftGraphDirectoryRole();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphDirectoryRole.withId(reader.getString());
                    continue;
                }
                if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphDirectoryRole.withDeletedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphDirectoryRole.description = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphDirectoryRole.displayName = reader.getString();
                    continue;
                }
                if ("roleTemplateId".equals(fieldName)) {
                    deserializedMicrosoftGraphDirectoryRole.roleTemplateId = reader.getString();
                    continue;
                }
                if ("members".equals(fieldName)) {
                    List members;
                    deserializedMicrosoftGraphDirectoryRole.members = members = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    continue;
                }
                if ("scopedMembers".equals(fieldName)) {
                    List scopedMembers;
                    deserializedMicrosoftGraphDirectoryRole.scopedMembers = scopedMembers = reader.readArray(reader1 -> MicrosoftGraphScopedRoleMembership.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphDirectoryRole.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphDirectoryRole;
        });
    }
}

