/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphNotebook;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteEntitySchemaObjectModel;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteSection;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPageLinks;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class MicrosoftGraphOnenotePage
extends MicrosoftGraphOnenoteEntitySchemaObjectModel {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private Base64Url content;
    private String contentUrl;
    private String createdByAppId;
    private OffsetDateTime lastModifiedDateTime;
    private Integer level;
    private MicrosoftGraphPageLinks links;
    private Integer order;
    private String title;
    private List<String> userTags;
    private MicrosoftGraphNotebook parentNotebook;
    private MicrosoftGraphOnenoteSection parentSection;
    private Map<String, Object> additionalProperties;

    public byte[] content() {
        if (this.content == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.content.decodedBytes();
    }

    public MicrosoftGraphOnenotePage withContent(byte[] content) {
        this.content = content == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])content));
        return this;
    }

    public String contentUrl() {
        return this.contentUrl;
    }

    public MicrosoftGraphOnenotePage withContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
        return this;
    }

    public String createdByAppId() {
        return this.createdByAppId;
    }

    public MicrosoftGraphOnenotePage withCreatedByAppId(String createdByAppId) {
        this.createdByAppId = createdByAppId;
        return this;
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public MicrosoftGraphOnenotePage withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    public Integer level() {
        return this.level;
    }

    public MicrosoftGraphOnenotePage withLevel(Integer level) {
        this.level = level;
        return this;
    }

    public MicrosoftGraphPageLinks links() {
        return this.links;
    }

    public MicrosoftGraphOnenotePage withLinks(MicrosoftGraphPageLinks links) {
        this.links = links;
        return this;
    }

    public Integer order() {
        return this.order;
    }

    public MicrosoftGraphOnenotePage withOrder(Integer order) {
        this.order = order;
        return this;
    }

    public String title() {
        return this.title;
    }

    public MicrosoftGraphOnenotePage withTitle(String title) {
        this.title = title;
        return this;
    }

    public List<String> userTags() {
        return this.userTags;
    }

    public MicrosoftGraphOnenotePage withUserTags(List<String> userTags) {
        this.userTags = userTags;
        return this;
    }

    public MicrosoftGraphNotebook parentNotebook() {
        return this.parentNotebook;
    }

    public MicrosoftGraphOnenotePage withParentNotebook(MicrosoftGraphNotebook parentNotebook) {
        this.parentNotebook = parentNotebook;
        return this;
    }

    public MicrosoftGraphOnenoteSection parentSection() {
        return this.parentSection;
    }

    public MicrosoftGraphOnenotePage withParentSection(MicrosoftGraphOnenoteSection parentSection) {
        this.parentSection = parentSection;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphOnenotePage withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphOnenotePage withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphOnenotePage withSelf(String self) {
        super.withSelf(self);
        return this;
    }

    @Override
    public MicrosoftGraphOnenotePage withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.links() != null) {
            this.links().validate();
        }
        if (this.parentNotebook() != null) {
            this.parentNotebook().validate();
        }
        if (this.parentSection() != null) {
            this.parentSection().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("self", this.self());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeStringField("content", Objects.toString(this.content, null));
        jsonWriter.writeStringField("contentUrl", this.contentUrl);
        jsonWriter.writeStringField("createdByAppId", this.createdByAppId);
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeNumberField("level", (Number)this.level);
        jsonWriter.writeJsonField("links", (JsonSerializable)this.links);
        jsonWriter.writeNumberField("order", (Number)this.order);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeArrayField("userTags", this.userTags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("parentNotebook", (JsonSerializable)this.parentNotebook);
        jsonWriter.writeJsonField("parentSection", (JsonSerializable)this.parentSection);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphOnenotePage fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphOnenotePage)jsonReader.readObject(reader -> {
            MicrosoftGraphOnenotePage deserializedMicrosoftGraphOnenotePage = new MicrosoftGraphOnenotePage();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePage.withId(reader.getString());
                    continue;
                }
                if ("self".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePage.withSelf(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePage.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("content".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePage.content = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("contentUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePage.contentUrl = reader.getString();
                    continue;
                }
                if ("createdByAppId".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePage.createdByAppId = reader.getString();
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePage.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("level".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePage.level = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("links".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePage.links = MicrosoftGraphPageLinks.fromJson(reader);
                    continue;
                }
                if ("order".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePage.order = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("title".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePage.title = reader.getString();
                    continue;
                }
                if ("userTags".equals(fieldName)) {
                    List userTags;
                    deserializedMicrosoftGraphOnenotePage.userTags = userTags = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("parentNotebook".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePage.parentNotebook = MicrosoftGraphNotebook.fromJson(reader);
                    continue;
                }
                if ("parentSection".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePage.parentSection = MicrosoftGraphOnenoteSection.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphOnenotePage.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphOnenotePage;
        });
    }
}

