/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.ExpandedProperties;
import com.azure.resourcemanager.authorization.models.MemberType;
import com.azure.resourcemanager.authorization.models.PrincipalType;
import com.azure.resourcemanager.authorization.models.Status;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class RoleEligibilityScheduleProperties
implements JsonSerializable<RoleEligibilityScheduleProperties> {
    private String scope;
    private String roleDefinitionId;
    private String principalId;
    private PrincipalType principalType;
    private String roleEligibilityScheduleRequestId;
    private MemberType memberType;
    private Status status;
    private OffsetDateTime startDateTime;
    private OffsetDateTime endDateTime;
    private String condition;
    private String conditionVersion;
    private OffsetDateTime createdOn;
    private OffsetDateTime updatedOn;
    private ExpandedProperties expandedProperties;

    public String scope() {
        return this.scope;
    }

    public RoleEligibilityScheduleProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String roleDefinitionId() {
        return this.roleDefinitionId;
    }

    public RoleEligibilityScheduleProperties withRoleDefinitionId(String roleDefinitionId) {
        this.roleDefinitionId = roleDefinitionId;
        return this;
    }

    public String principalId() {
        return this.principalId;
    }

    public RoleEligibilityScheduleProperties withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    public PrincipalType principalType() {
        return this.principalType;
    }

    public RoleEligibilityScheduleProperties withPrincipalType(PrincipalType principalType) {
        this.principalType = principalType;
        return this;
    }

    public String roleEligibilityScheduleRequestId() {
        return this.roleEligibilityScheduleRequestId;
    }

    public RoleEligibilityScheduleProperties withRoleEligibilityScheduleRequestId(String roleEligibilityScheduleRequestId) {
        this.roleEligibilityScheduleRequestId = roleEligibilityScheduleRequestId;
        return this;
    }

    public MemberType memberType() {
        return this.memberType;
    }

    public RoleEligibilityScheduleProperties withMemberType(MemberType memberType) {
        this.memberType = memberType;
        return this;
    }

    public Status status() {
        return this.status;
    }

    public RoleEligibilityScheduleProperties withStatus(Status status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    public RoleEligibilityScheduleProperties withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    public RoleEligibilityScheduleProperties withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    public String condition() {
        return this.condition;
    }

    public RoleEligibilityScheduleProperties withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public String conditionVersion() {
        return this.conditionVersion;
    }

    public RoleEligibilityScheduleProperties withConditionVersion(String conditionVersion) {
        this.conditionVersion = conditionVersion;
        return this;
    }

    public OffsetDateTime createdOn() {
        return this.createdOn;
    }

    public RoleEligibilityScheduleProperties withCreatedOn(OffsetDateTime createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    public OffsetDateTime updatedOn() {
        return this.updatedOn;
    }

    public RoleEligibilityScheduleProperties withUpdatedOn(OffsetDateTime updatedOn) {
        this.updatedOn = updatedOn;
        return this;
    }

    public ExpandedProperties expandedProperties() {
        return this.expandedProperties;
    }

    public RoleEligibilityScheduleProperties withExpandedProperties(ExpandedProperties expandedProperties) {
        this.expandedProperties = expandedProperties;
        return this;
    }

    public void validate() {
        if (this.expandedProperties() != null) {
            this.expandedProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeStringField("roleDefinitionId", this.roleDefinitionId);
        jsonWriter.writeStringField("principalId", this.principalId);
        jsonWriter.writeStringField("principalType", this.principalType == null ? null : this.principalType.toString());
        jsonWriter.writeStringField("roleEligibilityScheduleRequestId", this.roleEligibilityScheduleRequestId);
        jsonWriter.writeStringField("memberType", this.memberType == null ? null : this.memberType.toString());
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("startDateTime", this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        jsonWriter.writeStringField("endDateTime", this.endDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTime));
        jsonWriter.writeStringField("condition", this.condition);
        jsonWriter.writeStringField("conditionVersion", this.conditionVersion);
        jsonWriter.writeStringField("createdOn", this.createdOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdOn));
        jsonWriter.writeStringField("updatedOn", this.updatedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updatedOn));
        jsonWriter.writeJsonField("expandedProperties", (JsonSerializable)this.expandedProperties);
        return jsonWriter.writeEndObject();
    }

    public static RoleEligibilityScheduleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RoleEligibilityScheduleProperties)jsonReader.readObject(reader -> {
            RoleEligibilityScheduleProperties deserializedRoleEligibilityScheduleProperties = new RoleEligibilityScheduleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleProperties.scope = reader.getString();
                    continue;
                }
                if ("roleDefinitionId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleProperties.roleDefinitionId = reader.getString();
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleProperties.principalId = reader.getString();
                    continue;
                }
                if ("principalType".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleProperties.principalType = PrincipalType.fromString(reader.getString());
                    continue;
                }
                if ("roleEligibilityScheduleRequestId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleProperties.roleEligibilityScheduleRequestId = reader.getString();
                    continue;
                }
                if ("memberType".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleProperties.memberType = MemberType.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleProperties.status = Status.fromString(reader.getString());
                    continue;
                }
                if ("startDateTime".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleProperties.startDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endDateTime".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleProperties.endDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("condition".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleProperties.condition = reader.getString();
                    continue;
                }
                if ("conditionVersion".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleProperties.conditionVersion = reader.getString();
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleProperties.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("updatedOn".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleProperties.updatedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expandedProperties".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleProperties.expandedProperties = ExpandedProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleEligibilityScheduleProperties;
        });
    }
}

