/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphWorkbookOperationError;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphWorkbookOperationStatus;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphWorkbookOperation
extends MicrosoftGraphEntity {
    private MicrosoftGraphWorkbookOperationError error;
    private String resourceLocation;
    private MicrosoftGraphWorkbookOperationStatus status;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphWorkbookOperationError error() {
        return this.error;
    }

    public MicrosoftGraphWorkbookOperation withError(MicrosoftGraphWorkbookOperationError error) {
        this.error = error;
        return this;
    }

    public String resourceLocation() {
        return this.resourceLocation;
    }

    public MicrosoftGraphWorkbookOperation withResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
        return this;
    }

    public MicrosoftGraphWorkbookOperationStatus status() {
        return this.status;
    }

    public MicrosoftGraphWorkbookOperation withStatus(MicrosoftGraphWorkbookOperationStatus status) {
        this.status = status;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphWorkbookOperation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphWorkbookOperation withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.error() != null) {
            this.error().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeStringField("resourceLocation", this.resourceLocation);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphWorkbookOperation fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphWorkbookOperation)jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookOperation deserializedMicrosoftGraphWorkbookOperation = new MicrosoftGraphWorkbookOperation();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookOperation.withId(reader.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookOperation.error = MicrosoftGraphWorkbookOperationError.fromJson(reader);
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookOperation.resourceLocation = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookOperation.status = MicrosoftGraphWorkbookOperationStatus.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphWorkbookOperation.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphWorkbookOperation;
        });
    }
}

