// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The role management policy authentication context rule. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "ruleType")
@JsonTypeName("RoleManagementPolicyAuthenticationContextRule")
@Fluent
public final class RoleManagementPolicyAuthenticationContextRule extends RoleManagementPolicyRule {
    /*
     * The value indicating if rule is enabled.
     */
    @JsonProperty(value = "isEnabled")
    private Boolean isEnabled;

    /*
     * The claim value.
     */
    @JsonProperty(value = "claimValue")
    private String claimValue;

    /** Creates an instance of RoleManagementPolicyAuthenticationContextRule class. */
    public RoleManagementPolicyAuthenticationContextRule() {
    }

    /**
     * Get the isEnabled property: The value indicating if rule is enabled.
     *
     * @return the isEnabled value.
     */
    public Boolean isEnabled() {
        return this.isEnabled;
    }

    /**
     * Set the isEnabled property: The value indicating if rule is enabled.
     *
     * @param isEnabled the isEnabled value to set.
     * @return the RoleManagementPolicyAuthenticationContextRule object itself.
     */
    public RoleManagementPolicyAuthenticationContextRule withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    /**
     * Get the claimValue property: The claim value.
     *
     * @return the claimValue value.
     */
    public String claimValue() {
        return this.claimValue;
    }

    /**
     * Set the claimValue property: The claim value.
     *
     * @param claimValue the claimValue value to set.
     * @return the RoleManagementPolicyAuthenticationContextRule object itself.
     */
    public RoleManagementPolicyAuthenticationContextRule withClaimValue(String claimValue) {
        this.claimValue = claimValue;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RoleManagementPolicyAuthenticationContextRule withId(String id) {
        super.withId(id);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RoleManagementPolicyAuthenticationContextRule withTarget(RoleManagementPolicyRuleTarget target) {
        super.withTarget(target);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
