// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.authorization.models.PolicyProperties;
import com.azure.resourcemanager.authorization.models.Principal;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Role management policy properties with scope. */
@Fluent
public final class RoleManagementPolicyProperties {
    /*
     * The role management policy scope.
     */
    @JsonProperty(value = "scope")
    private String scope;

    /*
     * The role management policy display name.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * The role management policy description.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * The role management policy is default policy.
     */
    @JsonProperty(value = "isOrganizationDefault")
    private Boolean isOrganizationDefault;

    /*
     * The name of the entity last modified it
     */
    @JsonProperty(value = "lastModifiedBy", access = JsonProperty.Access.WRITE_ONLY)
    private Principal lastModifiedBy;

    /*
     * The last modified date time.
     */
    @JsonProperty(value = "lastModifiedDateTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastModifiedDateTime;

    /*
     * The rule applied to the policy.
     */
    @JsonProperty(value = "rules")
    private List<RoleManagementPolicyRule> rules;

    /*
     * The readonly computed rule applied to the policy.
     */
    @JsonProperty(value = "effectiveRules", access = JsonProperty.Access.WRITE_ONLY)
    private List<RoleManagementPolicyRule> effectiveRules;

    /*
     * Additional properties of scope
     */
    @JsonProperty(value = "policyProperties", access = JsonProperty.Access.WRITE_ONLY)
    private PolicyProperties policyProperties;

    /** Creates an instance of RoleManagementPolicyProperties class. */
    public RoleManagementPolicyProperties() {
    }

    /**
     * Get the scope property: The role management policy scope.
     *
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Set the scope property: The role management policy scope.
     *
     * @param scope the scope value to set.
     * @return the RoleManagementPolicyProperties object itself.
     */
    public RoleManagementPolicyProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the displayName property: The role management policy display name.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The role management policy display name.
     *
     * @param displayName the displayName value to set.
     * @return the RoleManagementPolicyProperties object itself.
     */
    public RoleManagementPolicyProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: The role management policy description.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The role management policy description.
     *
     * @param description the description value to set.
     * @return the RoleManagementPolicyProperties object itself.
     */
    public RoleManagementPolicyProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the isOrganizationDefault property: The role management policy is default policy.
     *
     * @return the isOrganizationDefault value.
     */
    public Boolean isOrganizationDefault() {
        return this.isOrganizationDefault;
    }

    /**
     * Set the isOrganizationDefault property: The role management policy is default policy.
     *
     * @param isOrganizationDefault the isOrganizationDefault value to set.
     * @return the RoleManagementPolicyProperties object itself.
     */
    public RoleManagementPolicyProperties withIsOrganizationDefault(Boolean isOrganizationDefault) {
        this.isOrganizationDefault = isOrganizationDefault;
        return this;
    }

    /**
     * Get the lastModifiedBy property: The name of the entity last modified it.
     *
     * @return the lastModifiedBy value.
     */
    public Principal lastModifiedBy() {
        return this.lastModifiedBy;
    }

    /**
     * Get the lastModifiedDateTime property: The last modified date time.
     *
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Get the rules property: The rule applied to the policy.
     *
     * @return the rules value.
     */
    public List<RoleManagementPolicyRule> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: The rule applied to the policy.
     *
     * @param rules the rules value to set.
     * @return the RoleManagementPolicyProperties object itself.
     */
    public RoleManagementPolicyProperties withRules(List<RoleManagementPolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Get the effectiveRules property: The readonly computed rule applied to the policy.
     *
     * @return the effectiveRules value.
     */
    public List<RoleManagementPolicyRule> effectiveRules() {
        return this.effectiveRules;
    }

    /**
     * Get the policyProperties property: Additional properties of scope.
     *
     * @return the policyProperties value.
     */
    public PolicyProperties policyProperties() {
        return this.policyProperties;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (lastModifiedBy() != null) {
            lastModifiedBy().validate();
        }
        if (rules() != null) {
            rules().forEach(e -> e.validate());
        }
        if (effectiveRules() != null) {
            effectiveRules().forEach(e -> e.validate());
        }
        if (policyProperties() != null) {
            policyProperties().validate();
        }
    }
}
