// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** pendingContentUpdate. */
@Fluent
public final class MicrosoftGraphPendingContentUpdate {
    /*
     * Date and time the pending binary operation was queued in UTC time. Read-only.
     */
    @JsonProperty(value = "queuedDateTime")
    private OffsetDateTime queuedDateTime;

    /*
     * pendingContentUpdate
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphPendingContentUpdate class. */
    public MicrosoftGraphPendingContentUpdate() {
    }

    /**
     * Get the queuedDateTime property: Date and time the pending binary operation was queued in UTC time. Read-only.
     *
     * @return the queuedDateTime value.
     */
    public OffsetDateTime queuedDateTime() {
        return this.queuedDateTime;
    }

    /**
     * Set the queuedDateTime property: Date and time the pending binary operation was queued in UTC time. Read-only.
     *
     * @param queuedDateTime the queuedDateTime value to set.
     * @return the MicrosoftGraphPendingContentUpdate object itself.
     */
    public MicrosoftGraphPendingContentUpdate withQueuedDateTime(OffsetDateTime queuedDateTime) {
        this.queuedDateTime = queuedDateTime;
        return this;
    }

    /**
     * Get the additionalProperties property: pendingContentUpdate.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: pendingContentUpdate.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPendingContentUpdate object itself.
     */
    public MicrosoftGraphPendingContentUpdate withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
