// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** internetMessageHeader. */
@Fluent
public final class MicrosoftGraphInternetMessageHeader {
    /*
     * Represents the key in a key-value pair.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The value in a key-value pair.
     */
    @JsonProperty(value = "value")
    private String value;

    /*
     * internetMessageHeader
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphInternetMessageHeader class. */
    public MicrosoftGraphInternetMessageHeader() {
    }

    /**
     * Get the name property: Represents the key in a key-value pair.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Represents the key in a key-value pair.
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphInternetMessageHeader object itself.
     */
    public MicrosoftGraphInternetMessageHeader withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: The value in a key-value pair.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value in a key-value pair.
     *
     * @param value the value value to set.
     * @return the MicrosoftGraphInternetMessageHeader object itself.
     */
    public MicrosoftGraphInternetMessageHeader withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the additionalProperties property: internetMessageHeader.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: internetMessageHeader.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphInternetMessageHeader object itself.
     */
    public MicrosoftGraphInternetMessageHeader withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
