// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** externalLink. */
@Fluent
public final class MicrosoftGraphExternalLink {
    /*
     * The url of the link.
     */
    @JsonProperty(value = "href")
    private String href;

    /*
     * externalLink
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphExternalLink class. */
    public MicrosoftGraphExternalLink() {
    }

    /**
     * Get the href property: The url of the link.
     *
     * @return the href value.
     */
    public String href() {
        return this.href;
    }

    /**
     * Set the href property: The url of the link.
     *
     * @param href the href value to set.
     * @return the MicrosoftGraphExternalLink object itself.
     */
    public MicrosoftGraphExternalLink withHref(String href) {
        this.href = href;
        return this;
    }

    /**
     * Get the additionalProperties property: externalLink.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: externalLink.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphExternalLink object itself.
     */
    public MicrosoftGraphExternalLink withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
