// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** employeeOrgData. */
@Fluent
public final class MicrosoftGraphEmployeeOrgData {
    /*
     * The cost center associated with the user. Returned only on $select. Supports $filter.
     */
    @JsonProperty(value = "costCenter")
    private String costCenter;

    /*
     * The name of the division in which the user works. Returned only on $select. Supports $filter.
     */
    @JsonProperty(value = "division")
    private String division;

    /*
     * employeeOrgData
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphEmployeeOrgData class. */
    public MicrosoftGraphEmployeeOrgData() {
    }

    /**
     * Get the costCenter property: The cost center associated with the user. Returned only on $select. Supports
     * $filter.
     *
     * @return the costCenter value.
     */
    public String costCenter() {
        return this.costCenter;
    }

    /**
     * Set the costCenter property: The cost center associated with the user. Returned only on $select. Supports
     * $filter.
     *
     * @param costCenter the costCenter value to set.
     * @return the MicrosoftGraphEmployeeOrgData object itself.
     */
    public MicrosoftGraphEmployeeOrgData withCostCenter(String costCenter) {
        this.costCenter = costCenter;
        return this;
    }

    /**
     * Get the division property: The name of the division in which the user works. Returned only on $select. Supports
     * $filter.
     *
     * @return the division value.
     */
    public String division() {
        return this.division;
    }

    /**
     * Set the division property: The name of the division in which the user works. Returned only on $select. Supports
     * $filter.
     *
     * @param division the division value to set.
     * @return the MicrosoftGraphEmployeeOrgData object itself.
     */
    public MicrosoftGraphEmployeeOrgData withDivision(String division) {
        this.division = division;
        return this;
    }

    /**
     * Get the additionalProperties property: employeeOrgData.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: employeeOrgData.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphEmployeeOrgData object itself.
     */
    public MicrosoftGraphEmployeeOrgData withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
