// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** dateTimeColumn. */
@Fluent
public final class MicrosoftGraphDateTimeColumn {
    /*
     * How the value should be presented in the UX. Must be one of default, friendly, or standard. See below for more
     * details. If unspecified, treated as default.
     */
    @JsonProperty(value = "displayAs")
    private String displayAs;

    /*
     * Indicates whether the value should be presented as a date only or a date and time. Must be one of dateOnly or
     * dateTime
     */
    @JsonProperty(value = "format")
    private String format;

    /*
     * dateTimeColumn
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphDateTimeColumn class. */
    public MicrosoftGraphDateTimeColumn() {
    }

    /**
     * Get the displayAs property: How the value should be presented in the UX. Must be one of default, friendly, or
     * standard. See below for more details. If unspecified, treated as default.
     *
     * @return the displayAs value.
     */
    public String displayAs() {
        return this.displayAs;
    }

    /**
     * Set the displayAs property: How the value should be presented in the UX. Must be one of default, friendly, or
     * standard. See below for more details. If unspecified, treated as default.
     *
     * @param displayAs the displayAs value to set.
     * @return the MicrosoftGraphDateTimeColumn object itself.
     */
    public MicrosoftGraphDateTimeColumn withDisplayAs(String displayAs) {
        this.displayAs = displayAs;
        return this;
    }

    /**
     * Get the format property: Indicates whether the value should be presented as a date only or a date and time. Must
     * be one of dateOnly or dateTime.
     *
     * @return the format value.
     */
    public String format() {
        return this.format;
    }

    /**
     * Set the format property: Indicates whether the value should be presented as a date only or a date and time. Must
     * be one of dateOnly or dateTime.
     *
     * @param format the format value to set.
     * @return the MicrosoftGraphDateTimeColumn object itself.
     */
    public MicrosoftGraphDateTimeColumn withFormat(String format) {
        this.format = format;
        return this;
    }

    /**
     * Get the additionalProperties property: dateTimeColumn.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: dateTimeColumn.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphDateTimeColumn object itself.
     */
    public MicrosoftGraphDateTimeColumn withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
