// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** columnDefinition. */
@Fluent
public final class MicrosoftGraphColumnDefinition extends MicrosoftGraphEntity {
    /*
     * booleanColumn
     */
    @JsonProperty(value = "boolean")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> booleanProperty;

    /*
     * calculatedColumn
     */
    @JsonProperty(value = "calculated")
    private MicrosoftGraphCalculatedColumn calculated;

    /*
     * choiceColumn
     */
    @JsonProperty(value = "choice")
    private MicrosoftGraphChoiceColumn choice;

    /*
     * For site columns, the name of the group this column belongs to. Helps organize related columns.
     */
    @JsonProperty(value = "columnGroup")
    private String columnGroup;

    /*
     * currencyColumn
     */
    @JsonProperty(value = "currency")
    private MicrosoftGraphCurrencyColumn currency;

    /*
     * dateTimeColumn
     */
    @JsonProperty(value = "dateTime")
    private MicrosoftGraphDateTimeColumn dateTime;

    /*
     * defaultColumnValue
     */
    @JsonProperty(value = "defaultValue")
    private MicrosoftGraphDefaultColumnValue defaultValue;

    /*
     * The user-facing description of the column.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * The user-facing name of the column.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * If true, no two list items may have the same value for this column.
     */
    @JsonProperty(value = "enforceUniqueValues")
    private Boolean enforceUniqueValues;

    /*
     * geolocationColumn
     */
    @JsonProperty(value = "geolocation")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> geolocation;

    /*
     * Specifies whether the column is displayed in the user interface.
     */
    @JsonProperty(value = "hidden")
    private Boolean hidden;

    /*
     * Specifies whether the column values can used for sorting and searching.
     */
    @JsonProperty(value = "indexed")
    private Boolean indexed;

    /*
     * lookupColumn
     */
    @JsonProperty(value = "lookup")
    private MicrosoftGraphLookupColumn lookup;

    /*
     * The API-facing name of the column as it appears in the [fields][] on a [listItem][]. For the user-facing name,
     * see displayName.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * numberColumn
     */
    @JsonProperty(value = "number")
    private MicrosoftGraphNumberColumn number;

    /*
     * personOrGroupColumn
     */
    @JsonProperty(value = "personOrGroup")
    private MicrosoftGraphPersonOrGroupColumn personOrGroup;

    /*
     * Specifies whether the column values can be modified.
     */
    @JsonProperty(value = "readOnly")
    private Boolean readOnly;

    /*
     * Specifies whether the column value is not optional.
     */
    @JsonProperty(value = "required")
    private Boolean required;

    /*
     * textColumn
     */
    @JsonProperty(value = "text")
    private MicrosoftGraphTextColumn text;

    /*
     * columnDefinition
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphColumnDefinition class. */
    public MicrosoftGraphColumnDefinition() {
    }

    /**
     * Get the booleanProperty property: booleanColumn.
     *
     * @return the booleanProperty value.
     */
    public Map<String, Object> booleanProperty() {
        return this.booleanProperty;
    }

    /**
     * Set the booleanProperty property: booleanColumn.
     *
     * @param booleanProperty the booleanProperty value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withBooleanProperty(Map<String, Object> booleanProperty) {
        this.booleanProperty = booleanProperty;
        return this;
    }

    /**
     * Get the calculated property: calculatedColumn.
     *
     * @return the calculated value.
     */
    public MicrosoftGraphCalculatedColumn calculated() {
        return this.calculated;
    }

    /**
     * Set the calculated property: calculatedColumn.
     *
     * @param calculated the calculated value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withCalculated(MicrosoftGraphCalculatedColumn calculated) {
        this.calculated = calculated;
        return this;
    }

    /**
     * Get the choice property: choiceColumn.
     *
     * @return the choice value.
     */
    public MicrosoftGraphChoiceColumn choice() {
        return this.choice;
    }

    /**
     * Set the choice property: choiceColumn.
     *
     * @param choice the choice value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withChoice(MicrosoftGraphChoiceColumn choice) {
        this.choice = choice;
        return this;
    }

    /**
     * Get the columnGroup property: For site columns, the name of the group this column belongs to. Helps organize
     * related columns.
     *
     * @return the columnGroup value.
     */
    public String columnGroup() {
        return this.columnGroup;
    }

    /**
     * Set the columnGroup property: For site columns, the name of the group this column belongs to. Helps organize
     * related columns.
     *
     * @param columnGroup the columnGroup value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withColumnGroup(String columnGroup) {
        this.columnGroup = columnGroup;
        return this;
    }

    /**
     * Get the currency property: currencyColumn.
     *
     * @return the currency value.
     */
    public MicrosoftGraphCurrencyColumn currency() {
        return this.currency;
    }

    /**
     * Set the currency property: currencyColumn.
     *
     * @param currency the currency value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withCurrency(MicrosoftGraphCurrencyColumn currency) {
        this.currency = currency;
        return this;
    }

    /**
     * Get the dateTime property: dateTimeColumn.
     *
     * @return the dateTime value.
     */
    public MicrosoftGraphDateTimeColumn dateTime() {
        return this.dateTime;
    }

    /**
     * Set the dateTime property: dateTimeColumn.
     *
     * @param dateTime the dateTime value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withDateTime(MicrosoftGraphDateTimeColumn dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    /**
     * Get the defaultValue property: defaultColumnValue.
     *
     * @return the defaultValue value.
     */
    public MicrosoftGraphDefaultColumnValue defaultValue() {
        return this.defaultValue;
    }

    /**
     * Set the defaultValue property: defaultColumnValue.
     *
     * @param defaultValue the defaultValue value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withDefaultValue(MicrosoftGraphDefaultColumnValue defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    /**
     * Get the description property: The user-facing description of the column.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The user-facing description of the column.
     *
     * @param description the description value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the displayName property: The user-facing name of the column.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The user-facing name of the column.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the enforceUniqueValues property: If true, no two list items may have the same value for this column.
     *
     * @return the enforceUniqueValues value.
     */
    public Boolean enforceUniqueValues() {
        return this.enforceUniqueValues;
    }

    /**
     * Set the enforceUniqueValues property: If true, no two list items may have the same value for this column.
     *
     * @param enforceUniqueValues the enforceUniqueValues value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withEnforceUniqueValues(Boolean enforceUniqueValues) {
        this.enforceUniqueValues = enforceUniqueValues;
        return this;
    }

    /**
     * Get the geolocation property: geolocationColumn.
     *
     * @return the geolocation value.
     */
    public Map<String, Object> geolocation() {
        return this.geolocation;
    }

    /**
     * Set the geolocation property: geolocationColumn.
     *
     * @param geolocation the geolocation value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withGeolocation(Map<String, Object> geolocation) {
        this.geolocation = geolocation;
        return this;
    }

    /**
     * Get the hidden property: Specifies whether the column is displayed in the user interface.
     *
     * @return the hidden value.
     */
    public Boolean hidden() {
        return this.hidden;
    }

    /**
     * Set the hidden property: Specifies whether the column is displayed in the user interface.
     *
     * @param hidden the hidden value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    /**
     * Get the indexed property: Specifies whether the column values can used for sorting and searching.
     *
     * @return the indexed value.
     */
    public Boolean indexed() {
        return this.indexed;
    }

    /**
     * Set the indexed property: Specifies whether the column values can used for sorting and searching.
     *
     * @param indexed the indexed value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withIndexed(Boolean indexed) {
        this.indexed = indexed;
        return this;
    }

    /**
     * Get the lookup property: lookupColumn.
     *
     * @return the lookup value.
     */
    public MicrosoftGraphLookupColumn lookup() {
        return this.lookup;
    }

    /**
     * Set the lookup property: lookupColumn.
     *
     * @param lookup the lookup value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withLookup(MicrosoftGraphLookupColumn lookup) {
        this.lookup = lookup;
        return this;
    }

    /**
     * Get the name property: The API-facing name of the column as it appears in the [fields][] on a [listItem][]. For
     * the user-facing name, see displayName.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The API-facing name of the column as it appears in the [fields][] on a [listItem][]. For
     * the user-facing name, see displayName.
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the number property: numberColumn.
     *
     * @return the number value.
     */
    public MicrosoftGraphNumberColumn number() {
        return this.number;
    }

    /**
     * Set the number property: numberColumn.
     *
     * @param number the number value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withNumber(MicrosoftGraphNumberColumn number) {
        this.number = number;
        return this;
    }

    /**
     * Get the personOrGroup property: personOrGroupColumn.
     *
     * @return the personOrGroup value.
     */
    public MicrosoftGraphPersonOrGroupColumn personOrGroup() {
        return this.personOrGroup;
    }

    /**
     * Set the personOrGroup property: personOrGroupColumn.
     *
     * @param personOrGroup the personOrGroup value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withPersonOrGroup(MicrosoftGraphPersonOrGroupColumn personOrGroup) {
        this.personOrGroup = personOrGroup;
        return this;
    }

    /**
     * Get the readOnly property: Specifies whether the column values can be modified.
     *
     * @return the readOnly value.
     */
    public Boolean readOnly() {
        return this.readOnly;
    }

    /**
     * Set the readOnly property: Specifies whether the column values can be modified.
     *
     * @param readOnly the readOnly value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    /**
     * Get the required property: Specifies whether the column value is not optional.
     *
     * @return the required value.
     */
    public Boolean required() {
        return this.required;
    }

    /**
     * Set the required property: Specifies whether the column value is not optional.
     *
     * @param required the required value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    /**
     * Get the text property: textColumn.
     *
     * @return the text value.
     */
    public MicrosoftGraphTextColumn text() {
        return this.text;
    }

    /**
     * Set the text property: textColumn.
     *
     * @param text the text value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withText(MicrosoftGraphTextColumn text) {
        this.text = text;
        return this;
    }

    /**
     * Get the additionalProperties property: columnDefinition.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: columnDefinition.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphColumnDefinition withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (calculated() != null) {
            calculated().validate();
        }
        if (choice() != null) {
            choice().validate();
        }
        if (currency() != null) {
            currency().validate();
        }
        if (dateTime() != null) {
            dateTime().validate();
        }
        if (defaultValue() != null) {
            defaultValue().validate();
        }
        if (lookup() != null) {
            lookup().validate();
        }
        if (number() != null) {
            number().validate();
        }
        if (personOrGroup() != null) {
            personOrGroup().validate();
        }
        if (text() != null) {
            text().validate();
        }
    }
}
