// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** baseItemVersion. */
@Fluent
public class MicrosoftGraphBaseItemVersion extends MicrosoftGraphEntity {
    /*
     * identitySet
     */
    @JsonProperty(value = "lastModifiedBy")
    private MicrosoftGraphIdentitySet lastModifiedBy;

    /*
     * Date and time the version was last modified. Read-only.
     */
    @JsonProperty(value = "lastModifiedDateTime")
    private OffsetDateTime lastModifiedDateTime;

    /*
     * publicationFacet
     */
    @JsonProperty(value = "publication")
    private MicrosoftGraphPublicationFacet publication;

    /*
     * baseItemVersion
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphBaseItemVersion class. */
    public MicrosoftGraphBaseItemVersion() {
    }

    /**
     * Get the lastModifiedBy property: identitySet.
     *
     * @return the lastModifiedBy value.
     */
    public MicrosoftGraphIdentitySet lastModifiedBy() {
        return this.lastModifiedBy;
    }

    /**
     * Set the lastModifiedBy property: identitySet.
     *
     * @param lastModifiedBy the lastModifiedBy value to set.
     * @return the MicrosoftGraphBaseItemVersion object itself.
     */
    public MicrosoftGraphBaseItemVersion withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    /**
     * Get the lastModifiedDateTime property: Date and time the version was last modified. Read-only.
     *
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Set the lastModifiedDateTime property: Date and time the version was last modified. Read-only.
     *
     * @param lastModifiedDateTime the lastModifiedDateTime value to set.
     * @return the MicrosoftGraphBaseItemVersion object itself.
     */
    public MicrosoftGraphBaseItemVersion withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    /**
     * Get the publication property: publicationFacet.
     *
     * @return the publication value.
     */
    public MicrosoftGraphPublicationFacet publication() {
        return this.publication;
    }

    /**
     * Set the publication property: publicationFacet.
     *
     * @param publication the publication value to set.
     * @return the MicrosoftGraphBaseItemVersion object itself.
     */
    public MicrosoftGraphBaseItemVersion withPublication(MicrosoftGraphPublicationFacet publication) {
        this.publication = publication;
        return this;
    }

    /**
     * Get the additionalProperties property: baseItemVersion.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: baseItemVersion.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphBaseItemVersion object itself.
     */
    public MicrosoftGraphBaseItemVersion withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphBaseItemVersion withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (lastModifiedBy() != null) {
            lastModifiedBy().validate();
        }
        if (publication() != null) {
            publication().validate();
        }
    }
}
