// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** workbookChartGridlines. */
@Fluent
public final class MicrosoftGraphWorkbookChartGridlines extends MicrosoftGraphEntity {
    /*
     * Boolean value representing if the axis gridlines are visible or not.
     */
    @JsonProperty(value = "visible")
    private Boolean visible;

    /*
     * workbookChartGridlinesFormat
     */
    @JsonProperty(value = "format")
    private MicrosoftGraphWorkbookChartGridlinesFormat format;

    /*
     * workbookChartGridlines
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphWorkbookChartGridlines class. */
    public MicrosoftGraphWorkbookChartGridlines() {
    }

    /**
     * Get the visible property: Boolean value representing if the axis gridlines are visible or not.
     *
     * @return the visible value.
     */
    public Boolean visible() {
        return this.visible;
    }

    /**
     * Set the visible property: Boolean value representing if the axis gridlines are visible or not.
     *
     * @param visible the visible value to set.
     * @return the MicrosoftGraphWorkbookChartGridlines object itself.
     */
    public MicrosoftGraphWorkbookChartGridlines withVisible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    /**
     * Get the format property: workbookChartGridlinesFormat.
     *
     * @return the format value.
     */
    public MicrosoftGraphWorkbookChartGridlinesFormat format() {
        return this.format;
    }

    /**
     * Set the format property: workbookChartGridlinesFormat.
     *
     * @param format the format value to set.
     * @return the MicrosoftGraphWorkbookChartGridlines object itself.
     */
    public MicrosoftGraphWorkbookChartGridlines withFormat(MicrosoftGraphWorkbookChartGridlinesFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartGridlines.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartGridlines.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartGridlines object itself.
     */
    public MicrosoftGraphWorkbookChartGridlines withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookChartGridlines withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (format() != null) {
            format().validate();
        }
    }
}
