// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** event. */
@Fluent
public final class MicrosoftGraphEvent extends MicrosoftGraphOutlookItem {
    /*
     * True if the meeting organizer allows invitees to propose a new time when responding, false otherwise. Optional.
     * Default is true.
     */
    @JsonProperty(value = "allowNewTimeProposals")
    private Boolean allowNewTimeProposals;

    /*
     * The collection of attendees for the event.
     */
    @JsonProperty(value = "attendees")
    private List<MicrosoftGraphAttendee> attendees;

    /*
     * itemBody
     */
    @JsonProperty(value = "body")
    private MicrosoftGraphItemBody body;

    /*
     * The preview of the message associated with the event. It is in text format.
     */
    @JsonProperty(value = "bodyPreview")
    private String bodyPreview;

    /*
     * dateTimeTimeZone
     */
    @JsonProperty(value = "end")
    private MicrosoftGraphDateTimeZone end;

    /*
     * Set to true if the event has attachments.
     */
    @JsonProperty(value = "hasAttachments")
    private Boolean hasAttachments;

    /*
     * The hideAttendees property.
     */
    @JsonProperty(value = "hideAttendees")
    private Boolean hideAttendees;

    /*
     * A unique identifier for an event across calendars. This ID is different for each occurrence in a recurring
     * series. Read-only.
     */
    @JsonProperty(value = "iCalUId")
    private String iCalUId;

    /*
     * importance
     */
    @JsonProperty(value = "importance")
    private MicrosoftGraphImportance importance;

    /*
     * Set to true if the event lasts all day.
     */
    @JsonProperty(value = "isAllDay")
    private Boolean isAllDay;

    /*
     * Set to true if the event has been canceled.
     */
    @JsonProperty(value = "isCancelled")
    private Boolean isCancelled;

    /*
     * The isDraft property.
     */
    @JsonProperty(value = "isDraft")
    private Boolean isDraft;

    /*
     * True if this event has online meeting information, false otherwise. Default is false. Optional.
     */
    @JsonProperty(value = "isOnlineMeeting")
    private Boolean isOnlineMeeting;

    /*
     * Set to true if the calendar owner (specified by the owner property of the calendar) is the organizer of the
     * event (specified by the organizer property of the event). This also applies if a delegate organized the event on
     * behalf of the owner.
     */
    @JsonProperty(value = "isOrganizer")
    private Boolean isOrganizer;

    /*
     * Set to true if an alert is set to remind the user of the event.
     */
    @JsonProperty(value = "isReminderOn")
    private Boolean isReminderOn;

    /*
     * location
     */
    @JsonProperty(value = "location")
    private MicrosoftGraphLocation location;

    /*
     * The locations where the event is held or attended from. The location and locations properties always correspond
     * with each other. If you update the location property, any prior locations in the locations collection would be
     * removed and replaced by the new location value.
     */
    @JsonProperty(value = "locations")
    private List<MicrosoftGraphLocation> locations;

    /*
     * onlineMeetingInfo
     */
    @JsonProperty(value = "onlineMeeting")
    private MicrosoftGraphOnlineMeetingInfo onlineMeeting;

    /*
     * onlineMeetingProviderType
     */
    @JsonProperty(value = "onlineMeetingProvider")
    private MicrosoftGraphOnlineMeetingProviderType onlineMeetingProvider;

    /*
     * A URL for an online meeting. The property is set only when an organizer specifies an event as an online meeting
     * such as a Skype meeting. Read-only.
     */
    @JsonProperty(value = "onlineMeetingUrl")
    private String onlineMeetingUrl;

    /*
     * recipient
     */
    @JsonProperty(value = "organizer")
    private MicrosoftGraphRecipient organizer;

    /*
     * The end time zone that was set when the event was created. A value of tzone://Microsoft/Custom indicates that a
     * legacy custom time zone was set in desktop Outlook.
     */
    @JsonProperty(value = "originalEndTimeZone")
    private String originalEndTimeZone;

    /*
     * The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For
     * example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    @JsonProperty(value = "originalStart")
    private OffsetDateTime originalStart;

    /*
     * The start time zone that was set when the event was created. A value of tzone://Microsoft/Custom indicates that
     * a legacy custom time zone was set in desktop Outlook.
     */
    @JsonProperty(value = "originalStartTimeZone")
    private String originalStartTimeZone;

    /*
     * patternedRecurrence
     */
    @JsonProperty(value = "recurrence")
    private MicrosoftGraphPatternedRecurrence recurrence;

    /*
     * The number of minutes before the event start time that the reminder alert occurs.
     */
    @JsonProperty(value = "reminderMinutesBeforeStart")
    private Integer reminderMinutesBeforeStart;

    /*
     * Default is true, which represents the organizer would like an invitee to send a response to the event.
     */
    @JsonProperty(value = "responseRequested")
    private Boolean responseRequested;

    /*
     * responseStatus
     */
    @JsonProperty(value = "responseStatus")
    private MicrosoftGraphResponseStatus responseStatus;

    /*
     * sensitivity
     */
    @JsonProperty(value = "sensitivity")
    private MicrosoftGraphSensitivity sensitivity;

    /*
     * The ID for the recurring series master item, if this event is part of a recurring series.
     */
    @JsonProperty(value = "seriesMasterId")
    private String seriesMasterId;

    /*
     * freeBusyStatus
     */
    @JsonProperty(value = "showAs")
    private MicrosoftGraphFreeBusyStatus showAs;

    /*
     * dateTimeTimeZone
     */
    @JsonProperty(value = "start")
    private MicrosoftGraphDateTimeZone start;

    /*
     * The text of the event's subject line.
     */
    @JsonProperty(value = "subject")
    private String subject;

    /*
     * A custom identifier specified by a client app for the server to avoid redundant POST operations in case of
     * client retries to create the same event. This is useful when low network connectivity causes the client to time
     * out before receiving a response from the server for the client's prior create-event request. After you set
     * transactionId when creating an event, you cannot change transactionId in a subsequent update. This property is
     * only returned in a response payload if an app has set it. Optional.
     */
    @JsonProperty(value = "transactionId")
    private String transactionId;

    /*
     * eventType
     */
    @JsonProperty(value = "type")
    private MicrosoftGraphEventType type;

    /*
     * The URL to open the event in Outlook on the web.Outlook on the web opens the event in the browser if you are
     * signed in to your mailbox. Otherwise, Outlook on the web prompts you to sign in.This URL cannot be accessed from
     * within an iFrame.
     */
    @JsonProperty(value = "webLink")
    private String webLink;

    /*
     * The collection of fileAttachment and itemAttachment attachments for the event. Navigation property. Read-only.
     * Nullable.
     */
    @JsonProperty(value = "attachments")
    private List<MicrosoftGraphAttachment> attachments;

    /*
     * calendar
     */
    @JsonProperty(value = "calendar")
    private MicrosoftGraphCalendar calendar;

    /*
     * The collection of open extensions defined for the event. Read-only. Nullable.
     */
    @JsonProperty(value = "extensions")
    private List<MicrosoftGraphExtension> extensions;

    /*
     * The instances of the event. Navigation property. Read-only. Nullable.
     */
    @JsonProperty(value = "instances")
    private List<MicrosoftGraphEvent> instances;

    /*
     * The collection of multi-value extended properties defined for the event. Read-only. Nullable.
     */
    @JsonProperty(value = "multiValueExtendedProperties")
    private List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties;

    /*
     * The collection of single-value extended properties defined for the event. Read-only. Nullable.
     */
    @JsonProperty(value = "singleValueExtendedProperties")
    private List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties;

    /*
     * event
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphEvent class. */
    public MicrosoftGraphEvent() {
    }

    /**
     * Get the allowNewTimeProposals property: True if the meeting organizer allows invitees to propose a new time when
     * responding, false otherwise. Optional. Default is true.
     *
     * @return the allowNewTimeProposals value.
     */
    public Boolean allowNewTimeProposals() {
        return this.allowNewTimeProposals;
    }

    /**
     * Set the allowNewTimeProposals property: True if the meeting organizer allows invitees to propose a new time when
     * responding, false otherwise. Optional. Default is true.
     *
     * @param allowNewTimeProposals the allowNewTimeProposals value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withAllowNewTimeProposals(Boolean allowNewTimeProposals) {
        this.allowNewTimeProposals = allowNewTimeProposals;
        return this;
    }

    /**
     * Get the attendees property: The collection of attendees for the event.
     *
     * @return the attendees value.
     */
    public List<MicrosoftGraphAttendee> attendees() {
        return this.attendees;
    }

    /**
     * Set the attendees property: The collection of attendees for the event.
     *
     * @param attendees the attendees value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withAttendees(List<MicrosoftGraphAttendee> attendees) {
        this.attendees = attendees;
        return this;
    }

    /**
     * Get the body property: itemBody.
     *
     * @return the body value.
     */
    public MicrosoftGraphItemBody body() {
        return this.body;
    }

    /**
     * Set the body property: itemBody.
     *
     * @param body the body value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withBody(MicrosoftGraphItemBody body) {
        this.body = body;
        return this;
    }

    /**
     * Get the bodyPreview property: The preview of the message associated with the event. It is in text format.
     *
     * @return the bodyPreview value.
     */
    public String bodyPreview() {
        return this.bodyPreview;
    }

    /**
     * Set the bodyPreview property: The preview of the message associated with the event. It is in text format.
     *
     * @param bodyPreview the bodyPreview value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withBodyPreview(String bodyPreview) {
        this.bodyPreview = bodyPreview;
        return this;
    }

    /**
     * Get the end property: dateTimeTimeZone.
     *
     * @return the end value.
     */
    public MicrosoftGraphDateTimeZone end() {
        return this.end;
    }

    /**
     * Set the end property: dateTimeTimeZone.
     *
     * @param end the end value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withEnd(MicrosoftGraphDateTimeZone end) {
        this.end = end;
        return this;
    }

    /**
     * Get the hasAttachments property: Set to true if the event has attachments.
     *
     * @return the hasAttachments value.
     */
    public Boolean hasAttachments() {
        return this.hasAttachments;
    }

    /**
     * Set the hasAttachments property: Set to true if the event has attachments.
     *
     * @param hasAttachments the hasAttachments value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    /**
     * Get the hideAttendees property: The hideAttendees property.
     *
     * @return the hideAttendees value.
     */
    public Boolean hideAttendees() {
        return this.hideAttendees;
    }

    /**
     * Set the hideAttendees property: The hideAttendees property.
     *
     * @param hideAttendees the hideAttendees value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withHideAttendees(Boolean hideAttendees) {
        this.hideAttendees = hideAttendees;
        return this;
    }

    /**
     * Get the iCalUId property: A unique identifier for an event across calendars. This ID is different for each
     * occurrence in a recurring series. Read-only.
     *
     * @return the iCalUId value.
     */
    public String iCalUId() {
        return this.iCalUId;
    }

    /**
     * Set the iCalUId property: A unique identifier for an event across calendars. This ID is different for each
     * occurrence in a recurring series. Read-only.
     *
     * @param iCalUId the iCalUId value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withICalUId(String iCalUId) {
        this.iCalUId = iCalUId;
        return this;
    }

    /**
     * Get the importance property: importance.
     *
     * @return the importance value.
     */
    public MicrosoftGraphImportance importance() {
        return this.importance;
    }

    /**
     * Set the importance property: importance.
     *
     * @param importance the importance value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withImportance(MicrosoftGraphImportance importance) {
        this.importance = importance;
        return this;
    }

    /**
     * Get the isAllDay property: Set to true if the event lasts all day.
     *
     * @return the isAllDay value.
     */
    public Boolean isAllDay() {
        return this.isAllDay;
    }

    /**
     * Set the isAllDay property: Set to true if the event lasts all day.
     *
     * @param isAllDay the isAllDay value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withIsAllDay(Boolean isAllDay) {
        this.isAllDay = isAllDay;
        return this;
    }

    /**
     * Get the isCancelled property: Set to true if the event has been canceled.
     *
     * @return the isCancelled value.
     */
    public Boolean isCancelled() {
        return this.isCancelled;
    }

    /**
     * Set the isCancelled property: Set to true if the event has been canceled.
     *
     * @param isCancelled the isCancelled value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withIsCancelled(Boolean isCancelled) {
        this.isCancelled = isCancelled;
        return this;
    }

    /**
     * Get the isDraft property: The isDraft property.
     *
     * @return the isDraft value.
     */
    public Boolean isDraft() {
        return this.isDraft;
    }

    /**
     * Set the isDraft property: The isDraft property.
     *
     * @param isDraft the isDraft value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withIsDraft(Boolean isDraft) {
        this.isDraft = isDraft;
        return this;
    }

    /**
     * Get the isOnlineMeeting property: True if this event has online meeting information, false otherwise. Default is
     * false. Optional.
     *
     * @return the isOnlineMeeting value.
     */
    public Boolean isOnlineMeeting() {
        return this.isOnlineMeeting;
    }

    /**
     * Set the isOnlineMeeting property: True if this event has online meeting information, false otherwise. Default is
     * false. Optional.
     *
     * @param isOnlineMeeting the isOnlineMeeting value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withIsOnlineMeeting(Boolean isOnlineMeeting) {
        this.isOnlineMeeting = isOnlineMeeting;
        return this;
    }

    /**
     * Get the isOrganizer property: Set to true if the calendar owner (specified by the owner property of the calendar)
     * is the organizer of the event (specified by the organizer property of the event). This also applies if a delegate
     * organized the event on behalf of the owner.
     *
     * @return the isOrganizer value.
     */
    public Boolean isOrganizer() {
        return this.isOrganizer;
    }

    /**
     * Set the isOrganizer property: Set to true if the calendar owner (specified by the owner property of the calendar)
     * is the organizer of the event (specified by the organizer property of the event). This also applies if a delegate
     * organized the event on behalf of the owner.
     *
     * @param isOrganizer the isOrganizer value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withIsOrganizer(Boolean isOrganizer) {
        this.isOrganizer = isOrganizer;
        return this;
    }

    /**
     * Get the isReminderOn property: Set to true if an alert is set to remind the user of the event.
     *
     * @return the isReminderOn value.
     */
    public Boolean isReminderOn() {
        return this.isReminderOn;
    }

    /**
     * Set the isReminderOn property: Set to true if an alert is set to remind the user of the event.
     *
     * @param isReminderOn the isReminderOn value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withIsReminderOn(Boolean isReminderOn) {
        this.isReminderOn = isReminderOn;
        return this;
    }

    /**
     * Get the location property: location.
     *
     * @return the location value.
     */
    public MicrosoftGraphLocation location() {
        return this.location;
    }

    /**
     * Set the location property: location.
     *
     * @param location the location value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withLocation(MicrosoftGraphLocation location) {
        this.location = location;
        return this;
    }

    /**
     * Get the locations property: The locations where the event is held or attended from. The location and locations
     * properties always correspond with each other. If you update the location property, any prior locations in the
     * locations collection would be removed and replaced by the new location value.
     *
     * @return the locations value.
     */
    public List<MicrosoftGraphLocation> locations() {
        return this.locations;
    }

    /**
     * Set the locations property: The locations where the event is held or attended from. The location and locations
     * properties always correspond with each other. If you update the location property, any prior locations in the
     * locations collection would be removed and replaced by the new location value.
     *
     * @param locations the locations value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withLocations(List<MicrosoftGraphLocation> locations) {
        this.locations = locations;
        return this;
    }

    /**
     * Get the onlineMeeting property: onlineMeetingInfo.
     *
     * @return the onlineMeeting value.
     */
    public MicrosoftGraphOnlineMeetingInfo onlineMeeting() {
        return this.onlineMeeting;
    }

    /**
     * Set the onlineMeeting property: onlineMeetingInfo.
     *
     * @param onlineMeeting the onlineMeeting value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withOnlineMeeting(MicrosoftGraphOnlineMeetingInfo onlineMeeting) {
        this.onlineMeeting = onlineMeeting;
        return this;
    }

    /**
     * Get the onlineMeetingProvider property: onlineMeetingProviderType.
     *
     * @return the onlineMeetingProvider value.
     */
    public MicrosoftGraphOnlineMeetingProviderType onlineMeetingProvider() {
        return this.onlineMeetingProvider;
    }

    /**
     * Set the onlineMeetingProvider property: onlineMeetingProviderType.
     *
     * @param onlineMeetingProvider the onlineMeetingProvider value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withOnlineMeetingProvider(
        MicrosoftGraphOnlineMeetingProviderType onlineMeetingProvider) {
        this.onlineMeetingProvider = onlineMeetingProvider;
        return this;
    }

    /**
     * Get the onlineMeetingUrl property: A URL for an online meeting. The property is set only when an organizer
     * specifies an event as an online meeting such as a Skype meeting. Read-only.
     *
     * @return the onlineMeetingUrl value.
     */
    public String onlineMeetingUrl() {
        return this.onlineMeetingUrl;
    }

    /**
     * Set the onlineMeetingUrl property: A URL for an online meeting. The property is set only when an organizer
     * specifies an event as an online meeting such as a Skype meeting. Read-only.
     *
     * @param onlineMeetingUrl the onlineMeetingUrl value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withOnlineMeetingUrl(String onlineMeetingUrl) {
        this.onlineMeetingUrl = onlineMeetingUrl;
        return this;
    }

    /**
     * Get the organizer property: recipient.
     *
     * @return the organizer value.
     */
    public MicrosoftGraphRecipient organizer() {
        return this.organizer;
    }

    /**
     * Set the organizer property: recipient.
     *
     * @param organizer the organizer value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withOrganizer(MicrosoftGraphRecipient organizer) {
        this.organizer = organizer;
        return this;
    }

    /**
     * Get the originalEndTimeZone property: The end time zone that was set when the event was created. A value of
     * tzone://Microsoft/Custom indicates that a legacy custom time zone was set in desktop Outlook.
     *
     * @return the originalEndTimeZone value.
     */
    public String originalEndTimeZone() {
        return this.originalEndTimeZone;
    }

    /**
     * Set the originalEndTimeZone property: The end time zone that was set when the event was created. A value of
     * tzone://Microsoft/Custom indicates that a legacy custom time zone was set in desktop Outlook.
     *
     * @param originalEndTimeZone the originalEndTimeZone value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withOriginalEndTimeZone(String originalEndTimeZone) {
        this.originalEndTimeZone = originalEndTimeZone;
        return this;
    }

    /**
     * Get the originalStart property: The Timestamp type represents date and time information using ISO 8601 format and
     * is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     *
     * @return the originalStart value.
     */
    public OffsetDateTime originalStart() {
        return this.originalStart;
    }

    /**
     * Set the originalStart property: The Timestamp type represents date and time information using ISO 8601 format and
     * is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     *
     * @param originalStart the originalStart value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withOriginalStart(OffsetDateTime originalStart) {
        this.originalStart = originalStart;
        return this;
    }

    /**
     * Get the originalStartTimeZone property: The start time zone that was set when the event was created. A value of
     * tzone://Microsoft/Custom indicates that a legacy custom time zone was set in desktop Outlook.
     *
     * @return the originalStartTimeZone value.
     */
    public String originalStartTimeZone() {
        return this.originalStartTimeZone;
    }

    /**
     * Set the originalStartTimeZone property: The start time zone that was set when the event was created. A value of
     * tzone://Microsoft/Custom indicates that a legacy custom time zone was set in desktop Outlook.
     *
     * @param originalStartTimeZone the originalStartTimeZone value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withOriginalStartTimeZone(String originalStartTimeZone) {
        this.originalStartTimeZone = originalStartTimeZone;
        return this;
    }

    /**
     * Get the recurrence property: patternedRecurrence.
     *
     * @return the recurrence value.
     */
    public MicrosoftGraphPatternedRecurrence recurrence() {
        return this.recurrence;
    }

    /**
     * Set the recurrence property: patternedRecurrence.
     *
     * @param recurrence the recurrence value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withRecurrence(MicrosoftGraphPatternedRecurrence recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    /**
     * Get the reminderMinutesBeforeStart property: The number of minutes before the event start time that the reminder
     * alert occurs.
     *
     * @return the reminderMinutesBeforeStart value.
     */
    public Integer reminderMinutesBeforeStart() {
        return this.reminderMinutesBeforeStart;
    }

    /**
     * Set the reminderMinutesBeforeStart property: The number of minutes before the event start time that the reminder
     * alert occurs.
     *
     * @param reminderMinutesBeforeStart the reminderMinutesBeforeStart value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withReminderMinutesBeforeStart(Integer reminderMinutesBeforeStart) {
        this.reminderMinutesBeforeStart = reminderMinutesBeforeStart;
        return this;
    }

    /**
     * Get the responseRequested property: Default is true, which represents the organizer would like an invitee to send
     * a response to the event.
     *
     * @return the responseRequested value.
     */
    public Boolean responseRequested() {
        return this.responseRequested;
    }

    /**
     * Set the responseRequested property: Default is true, which represents the organizer would like an invitee to send
     * a response to the event.
     *
     * @param responseRequested the responseRequested value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withResponseRequested(Boolean responseRequested) {
        this.responseRequested = responseRequested;
        return this;
    }

    /**
     * Get the responseStatus property: responseStatus.
     *
     * @return the responseStatus value.
     */
    public MicrosoftGraphResponseStatus responseStatus() {
        return this.responseStatus;
    }

    /**
     * Set the responseStatus property: responseStatus.
     *
     * @param responseStatus the responseStatus value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withResponseStatus(MicrosoftGraphResponseStatus responseStatus) {
        this.responseStatus = responseStatus;
        return this;
    }

    /**
     * Get the sensitivity property: sensitivity.
     *
     * @return the sensitivity value.
     */
    public MicrosoftGraphSensitivity sensitivity() {
        return this.sensitivity;
    }

    /**
     * Set the sensitivity property: sensitivity.
     *
     * @param sensitivity the sensitivity value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withSensitivity(MicrosoftGraphSensitivity sensitivity) {
        this.sensitivity = sensitivity;
        return this;
    }

    /**
     * Get the seriesMasterId property: The ID for the recurring series master item, if this event is part of a
     * recurring series.
     *
     * @return the seriesMasterId value.
     */
    public String seriesMasterId() {
        return this.seriesMasterId;
    }

    /**
     * Set the seriesMasterId property: The ID for the recurring series master item, if this event is part of a
     * recurring series.
     *
     * @param seriesMasterId the seriesMasterId value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withSeriesMasterId(String seriesMasterId) {
        this.seriesMasterId = seriesMasterId;
        return this;
    }

    /**
     * Get the showAs property: freeBusyStatus.
     *
     * @return the showAs value.
     */
    public MicrosoftGraphFreeBusyStatus showAs() {
        return this.showAs;
    }

    /**
     * Set the showAs property: freeBusyStatus.
     *
     * @param showAs the showAs value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withShowAs(MicrosoftGraphFreeBusyStatus showAs) {
        this.showAs = showAs;
        return this;
    }

    /**
     * Get the start property: dateTimeTimeZone.
     *
     * @return the start value.
     */
    public MicrosoftGraphDateTimeZone start() {
        return this.start;
    }

    /**
     * Set the start property: dateTimeTimeZone.
     *
     * @param start the start value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withStart(MicrosoftGraphDateTimeZone start) {
        this.start = start;
        return this;
    }

    /**
     * Get the subject property: The text of the event's subject line.
     *
     * @return the subject value.
     */
    public String subject() {
        return this.subject;
    }

    /**
     * Set the subject property: The text of the event's subject line.
     *
     * @param subject the subject value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
     * Get the transactionId property: A custom identifier specified by a client app for the server to avoid redundant
     * POST operations in case of client retries to create the same event. This is useful when low network connectivity
     * causes the client to time out before receiving a response from the server for the client's prior create-event
     * request. After you set transactionId when creating an event, you cannot change transactionId in a subsequent
     * update. This property is only returned in a response payload if an app has set it. Optional.
     *
     * @return the transactionId value.
     */
    public String transactionId() {
        return this.transactionId;
    }

    /**
     * Set the transactionId property: A custom identifier specified by a client app for the server to avoid redundant
     * POST operations in case of client retries to create the same event. This is useful when low network connectivity
     * causes the client to time out before receiving a response from the server for the client's prior create-event
     * request. After you set transactionId when creating an event, you cannot change transactionId in a subsequent
     * update. This property is only returned in a response payload if an app has set it. Optional.
     *
     * @param transactionId the transactionId value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    /**
     * Get the type property: eventType.
     *
     * @return the type value.
     */
    public MicrosoftGraphEventType type() {
        return this.type;
    }

    /**
     * Set the type property: eventType.
     *
     * @param type the type value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withType(MicrosoftGraphEventType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the webLink property: The URL to open the event in Outlook on the web.Outlook on the web opens the event in
     * the browser if you are signed in to your mailbox. Otherwise, Outlook on the web prompts you to sign in.This URL
     * cannot be accessed from within an iFrame.
     *
     * @return the webLink value.
     */
    public String webLink() {
        return this.webLink;
    }

    /**
     * Set the webLink property: The URL to open the event in Outlook on the web.Outlook on the web opens the event in
     * the browser if you are signed in to your mailbox. Otherwise, Outlook on the web prompts you to sign in.This URL
     * cannot be accessed from within an iFrame.
     *
     * @param webLink the webLink value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withWebLink(String webLink) {
        this.webLink = webLink;
        return this;
    }

    /**
     * Get the attachments property: The collection of fileAttachment and itemAttachment attachments for the event.
     * Navigation property. Read-only. Nullable.
     *
     * @return the attachments value.
     */
    public List<MicrosoftGraphAttachment> attachments() {
        return this.attachments;
    }

    /**
     * Set the attachments property: The collection of fileAttachment and itemAttachment attachments for the event.
     * Navigation property. Read-only. Nullable.
     *
     * @param attachments the attachments value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withAttachments(List<MicrosoftGraphAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    /**
     * Get the calendar property: calendar.
     *
     * @return the calendar value.
     */
    public MicrosoftGraphCalendar calendar() {
        return this.calendar;
    }

    /**
     * Set the calendar property: calendar.
     *
     * @param calendar the calendar value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withCalendar(MicrosoftGraphCalendar calendar) {
        this.calendar = calendar;
        return this;
    }

    /**
     * Get the extensions property: The collection of open extensions defined for the event. Read-only. Nullable.
     *
     * @return the extensions value.
     */
    public List<MicrosoftGraphExtension> extensions() {
        return this.extensions;
    }

    /**
     * Set the extensions property: The collection of open extensions defined for the event. Read-only. Nullable.
     *
     * @param extensions the extensions value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withExtensions(List<MicrosoftGraphExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    /**
     * Get the instances property: The instances of the event. Navigation property. Read-only. Nullable.
     *
     * @return the instances value.
     */
    public List<MicrosoftGraphEvent> instances() {
        return this.instances;
    }

    /**
     * Set the instances property: The instances of the event. Navigation property. Read-only. Nullable.
     *
     * @param instances the instances value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withInstances(List<MicrosoftGraphEvent> instances) {
        this.instances = instances;
        return this;
    }

    /**
     * Get the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * event. Read-only. Nullable.
     *
     * @return the multiValueExtendedProperties value.
     */
    public List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties() {
        return this.multiValueExtendedProperties;
    }

    /**
     * Set the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * event. Read-only. Nullable.
     *
     * @param multiValueExtendedProperties the multiValueExtendedProperties value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withMultiValueExtendedProperties(
        List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        this.multiValueExtendedProperties = multiValueExtendedProperties;
        return this;
    }

    /**
     * Get the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the event. Read-only. Nullable.
     *
     * @return the singleValueExtendedProperties value.
     */
    public List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties() {
        return this.singleValueExtendedProperties;
    }

    /**
     * Set the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the event. Read-only. Nullable.
     *
     * @param singleValueExtendedProperties the singleValueExtendedProperties value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withSingleValueExtendedProperties(
        List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        this.singleValueExtendedProperties = singleValueExtendedProperties;
        return this;
    }

    /**
     * Get the additionalProperties property: event.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: event.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphEvent object itself.
     */
    public MicrosoftGraphEvent withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphEvent withCategories(List<String> categories) {
        super.withCategories(categories);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphEvent withChangeKey(String changeKey) {
        super.withChangeKey(changeKey);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphEvent withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphEvent withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphEvent withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (attendees() != null) {
            attendees().forEach(e -> e.validate());
        }
        if (body() != null) {
            body().validate();
        }
        if (end() != null) {
            end().validate();
        }
        if (location() != null) {
            location().validate();
        }
        if (locations() != null) {
            locations().forEach(e -> e.validate());
        }
        if (onlineMeeting() != null) {
            onlineMeeting().validate();
        }
        if (organizer() != null) {
            organizer().validate();
        }
        if (recurrence() != null) {
            recurrence().validate();
        }
        if (responseStatus() != null) {
            responseStatus().validate();
        }
        if (start() != null) {
            start().validate();
        }
        if (attachments() != null) {
            attachments().forEach(e -> e.validate());
        }
        if (calendar() != null) {
            calendar().validate();
        }
        if (extensions() != null) {
            extensions().forEach(e -> e.validate());
        }
        if (instances() != null) {
            instances().forEach(e -> e.validate());
        }
        if (multiValueExtendedProperties() != null) {
            multiValueExtendedProperties().forEach(e -> e.validate());
        }
        if (singleValueExtendedProperties() != null) {
            singleValueExtendedProperties().forEach(e -> e.validate());
        }
    }
}
