// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.ProviderOperationsMetadataInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ProviderOperationsMetadatasClient. */
public interface ProviderOperationsMetadatasClient {
    /**
     * Gets provider operations metadata for the specified resource provider.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param expand Specifies whether to expand the values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return provider operations metadata for the specified resource provider along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ProviderOperationsMetadataInner>> getWithResponseAsync(
        String resourceProviderNamespace, String expand);

    /**
     * Gets provider operations metadata for the specified resource provider.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return provider operations metadata for the specified resource provider on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ProviderOperationsMetadataInner> getAsync(String resourceProviderNamespace);

    /**
     * Gets provider operations metadata for the specified resource provider.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param expand Specifies whether to expand the values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return provider operations metadata for the specified resource provider along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ProviderOperationsMetadataInner> getWithResponse(
        String resourceProviderNamespace, String expand, Context context);

    /**
     * Gets provider operations metadata for the specified resource provider.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return provider operations metadata for the specified resource provider.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProviderOperationsMetadataInner get(String resourceProviderNamespace);

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @param expand Specifies whether to expand the values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return provider operations metadata for all resource providers as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ProviderOperationsMetadataInner> listAsync(String expand);

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return provider operations metadata for all resource providers as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ProviderOperationsMetadataInner> listAsync();

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return provider operations metadata for all resource providers as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProviderOperationsMetadataInner> list();

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @param expand Specifies whether to expand the values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return provider operations metadata for all resource providers as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProviderOperationsMetadataInner> list(String expand, Context context);
}
