/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.UsersTodoListsTasksClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfExtension1;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinkedResource;
import com.azure.resourcemanager.authorization.fluent.models.Get5ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphLinkedResourceInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoListsTasksOrderby;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoListsTasksSelect;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class UsersTodoListsTasksClientImpl
implements UsersTodoListsTasksClient {
    private final ClientLogger logger = new ClientLogger(UsersTodoListsTasksClientImpl.class);
    private final UsersTodoListsTasksService service;
    private final MicrosoftGraphClientImpl client;

    UsersTodoListsTasksClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (UsersTodoListsTasksService)RestProxy.create(UsersTodoListsTasksService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(String userId, String todoTaskListId, String todoTaskId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsTasksOrderby> orderby, List<String> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listExtensions(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension1)res.getValue()).value(), ((CollectionOfExtension1)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(String userId, String todoTaskListId, String todoTaskId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsTasksOrderby> orderby, List<String> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listExtensions(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension1)res.getValue()).value(), ((CollectionOfExtension1)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String userId, String todoTaskListId, String todoTaskId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsTasksOrderby> orderby, List<String> select, List<String> expand) {
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String userId, String todoTaskListId, String todoTaskId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String userId, String todoTaskListId, String todoTaskId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsTasksOrderby> orderby, List<String> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String userId, String todoTaskListId, String todoTaskId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersTodoListsTasksOrderby> orderby = null;
        List<String> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listExtensionsAsync(userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String userId, String todoTaskListId, String todoTaskId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsTasksOrderby> orderby, List<String> select, List<String> expand, Context context) {
        return new PagedIterable(this.listExtensionsAsync(userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createExtensions(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createExtensions(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphExtensionInner> createExtensionsAsync(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphExtensionInner body) {
        return this.createExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphExtensionInner createExtensions(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphExtensionInner body) {
        return (MicrosoftGraphExtensionInner)this.createExtensionsAsync(userId, todoTaskListId, todoTaskId, body).block();
    }

    @Override
    public Response<MicrosoftGraphExtensionInner> createExtensionsWithResponse(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphExtensionInner body, Context context) {
        return (Response)this.createExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, String extensionId, List<String> select, List<Get5ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getExtensions(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, extensionId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, String extensionId, List<String> select, List<Get5ItemsItem> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getExtensions(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, extensionId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(String userId, String todoTaskListId, String todoTaskId, String extensionId, List<String> select, List<Get5ItemsItem> expand) {
        return this.getExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(String userId, String todoTaskListId, String todoTaskId, String extensionId) {
        List<String> select = null;
        List<Get5ItemsItem> expand = null;
        return this.getExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphExtensionInner getExtensions(String userId, String todoTaskListId, String todoTaskId, String extensionId) {
        List<String> select = null;
        List<Get5ItemsItem> expand = null;
        return (MicrosoftGraphExtensionInner)this.getExtensionsAsync(userId, todoTaskListId, todoTaskId, extensionId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphExtensionInner> getExtensionsWithResponse(String userId, String todoTaskListId, String todoTaskId, String extensionId, List<String> select, List<Get5ItemsItem> expand, Context context) {
        return (Response)this.getExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateExtensionsWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, String extensionId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateExtensions(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, extensionId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateExtensionsWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateExtensions(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, extensionId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateExtensionsAsync(String userId, String todoTaskListId, String todoTaskId, String extensionId, MicrosoftGraphExtensionInner body) {
        return this.updateExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateExtensions(String userId, String todoTaskListId, String todoTaskId, String extensionId, MicrosoftGraphExtensionInner body) {
        this.updateExtensionsAsync(userId, todoTaskListId, todoTaskId, extensionId, body).block();
    }

    @Override
    public Response<Void> updateExtensionsWithResponse(String userId, String todoTaskListId, String todoTaskId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        return (Response)this.updateExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteExtensionsWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, String extensionId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteExtensions(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, extensionId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteExtensionsWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, String extensionId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteExtensions(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, extensionId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteExtensionsAsync(String userId, String todoTaskListId, String todoTaskId, String extensionId, String ifMatch) {
        return this.deleteExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteExtensionsAsync(String userId, String todoTaskListId, String todoTaskId, String extensionId) {
        String ifMatch = null;
        return this.deleteExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteExtensions(String userId, String todoTaskListId, String todoTaskId, String extensionId) {
        String ifMatch = null;
        this.deleteExtensionsAsync(userId, todoTaskListId, todoTaskId, extensionId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteExtensionsWithResponse(String userId, String todoTaskListId, String todoTaskId, String extensionId, String ifMatch, Context context) {
        return (Response)this.deleteExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphLinkedResourceInner>> listLinkedResourcesSinglePageAsync(String userId, String todoTaskListId, String todoTaskId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsTasksOrderby> orderby, List<UsersTodoListsTasksSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listLinkedResources(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinkedResource)res.getValue()).value(), ((CollectionOfLinkedResource)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphLinkedResourceInner>> listLinkedResourcesSinglePageAsync(String userId, String todoTaskListId, String todoTaskId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsTasksOrderby> orderby, List<UsersTodoListsTasksSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listLinkedResources(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinkedResource)res.getValue()).value(), ((CollectionOfLinkedResource)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphLinkedResourceInner> listLinkedResourcesAsync(String userId, String todoTaskListId, String todoTaskId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsTasksOrderby> orderby, List<UsersTodoListsTasksSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listLinkedResourcesSinglePageAsync(userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listLinkedResourcesNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphLinkedResourceInner> listLinkedResourcesAsync(String userId, String todoTaskListId, String todoTaskId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listLinkedResourcesSinglePageAsync(userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listLinkedResourcesNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphLinkedResourceInner> listLinkedResourcesAsync(String userId, String todoTaskListId, String todoTaskId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsTasksOrderby> orderby, List<UsersTodoListsTasksSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listLinkedResourcesSinglePageAsync(userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listLinkedResourcesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphLinkedResourceInner> listLinkedResources(String userId, String todoTaskListId, String todoTaskId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersTodoListsTasksOrderby> orderby = null;
        List<UsersTodoListsTasksSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listLinkedResourcesAsync(userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphLinkedResourceInner> listLinkedResources(String userId, String todoTaskListId, String todoTaskId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsTasksOrderby> orderby, List<UsersTodoListsTasksSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listLinkedResourcesAsync(userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphLinkedResourceInner>> createLinkedResourcesWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphLinkedResourceInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createLinkedResources(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphLinkedResourceInner>> createLinkedResourcesWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphLinkedResourceInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createLinkedResources(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphLinkedResourceInner> createLinkedResourcesAsync(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphLinkedResourceInner body) {
        return this.createLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphLinkedResourceInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphLinkedResourceInner createLinkedResources(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphLinkedResourceInner body) {
        return (MicrosoftGraphLinkedResourceInner)this.createLinkedResourcesAsync(userId, todoTaskListId, todoTaskId, body).block();
    }

    @Override
    public Response<MicrosoftGraphLinkedResourceInner> createLinkedResourcesWithResponse(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphLinkedResourceInner body, Context context) {
        return (Response)this.createLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphLinkedResourceInner>> getLinkedResourcesWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, List<UsersTodoListsTasksSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (linkedResourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedResourceId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getLinkedResources(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, linkedResourceId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphLinkedResourceInner>> getLinkedResourcesWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, List<UsersTodoListsTasksSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (linkedResourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedResourceId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getLinkedResources(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, linkedResourceId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphLinkedResourceInner> getLinkedResourcesAsync(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, List<UsersTodoListsTasksSelect> select, List<String> expand) {
        return this.getLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphLinkedResourceInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphLinkedResourceInner> getLinkedResourcesAsync(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId) {
        List<UsersTodoListsTasksSelect> select = null;
        List<String> expand = null;
        return this.getLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphLinkedResourceInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphLinkedResourceInner getLinkedResources(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId) {
        List<UsersTodoListsTasksSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphLinkedResourceInner)this.getLinkedResourcesAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphLinkedResourceInner> getLinkedResourcesWithResponse(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, List<UsersTodoListsTasksSelect> select, List<String> expand, Context context) {
        return (Response)this.getLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateLinkedResourcesWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, MicrosoftGraphLinkedResourceInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (linkedResourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedResourceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateLinkedResources(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, linkedResourceId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateLinkedResourcesWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, MicrosoftGraphLinkedResourceInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (linkedResourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedResourceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateLinkedResources(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, linkedResourceId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateLinkedResourcesAsync(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, MicrosoftGraphLinkedResourceInner body) {
        return this.updateLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateLinkedResources(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, MicrosoftGraphLinkedResourceInner body) {
        this.updateLinkedResourcesAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, body).block();
    }

    @Override
    public Response<Void> updateLinkedResourcesWithResponse(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, MicrosoftGraphLinkedResourceInner body, Context context) {
        return (Response)this.updateLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteLinkedResourcesWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (linkedResourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedResourceId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteLinkedResources(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, linkedResourceId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteLinkedResourcesWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (linkedResourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedResourceId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteLinkedResources(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, linkedResourceId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteLinkedResourcesAsync(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, String ifMatch) {
        return this.deleteLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteLinkedResourcesAsync(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId) {
        String ifMatch = null;
        return this.deleteLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteLinkedResources(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId) {
        String ifMatch = null;
        this.deleteLinkedResourcesAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteLinkedResourcesWithResponse(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, String ifMatch, Context context) {
        return (Response)this.deleteLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension1)res.getValue()).value(), ((CollectionOfExtension1)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension1)res.getValue()).value(), ((CollectionOfExtension1)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphLinkedResourceInner>> listLinkedResourcesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listLinkedResourcesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinkedResource)res.getValue()).value(), ((CollectionOfLinkedResource)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphLinkedResourceInner>> listLinkedResourcesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listLinkedResourcesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinkedResource)res.getValue()).value(), ((CollectionOfLinkedResource)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface UsersTodoListsTasksService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/extensions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfExtension1>> listExtensions(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="todoTask-id") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$skip") Integer var6, @QueryParam(value="$search") String var7, @QueryParam(value="$filter") String var8, @QueryParam(value="$count") Boolean var9, @QueryParam(value="$orderby") String var10, @QueryParam(value="$select") String var11, @QueryParam(value="$expand") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/extensions")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphExtensionInner>> createExtensions(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="todoTask-id") String var4, @BodyParam(value="application/json") MicrosoftGraphExtensionInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/extensions/{extension-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphExtensionInner>> getExtensions(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="todoTask-id") String var4, @PathParam(value="extension-id") String var5, @QueryParam(value="$select") String var6, @QueryParam(value="$expand") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/extensions/{extension-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateExtensions(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="todoTask-id") String var4, @PathParam(value="extension-id") String var5, @BodyParam(value="application/json") MicrosoftGraphExtensionInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/extensions/{extension-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteExtensions(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="todoTask-id") String var4, @PathParam(value="extension-id") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/linkedResources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinkedResource>> listLinkedResources(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="todoTask-id") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$skip") Integer var6, @QueryParam(value="$search") String var7, @QueryParam(value="$filter") String var8, @QueryParam(value="$count") Boolean var9, @QueryParam(value="$orderby") String var10, @QueryParam(value="$select") String var11, @QueryParam(value="$expand") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/linkedResources")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphLinkedResourceInner>> createLinkedResources(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="todoTask-id") String var4, @BodyParam(value="application/json") MicrosoftGraphLinkedResourceInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/linkedResources/{linkedResource-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphLinkedResourceInner>> getLinkedResources(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="todoTask-id") String var4, @PathParam(value="linkedResource-id") String var5, @QueryParam(value="$select") String var6, @QueryParam(value="$expand") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/linkedResources/{linkedResource-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateLinkedResources(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="todoTask-id") String var4, @PathParam(value="linkedResource-id") String var5, @BodyParam(value="application/json") MicrosoftGraphLinkedResourceInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/linkedResources/{linkedResource-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteLinkedResources(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="todoTask-id") String var4, @PathParam(value="linkedResource-id") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfExtension1>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinkedResource>> listLinkedResourcesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

