// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The ExpandedProperties model. */
@Fluent
public final class ExpandedProperties {
    /*
     * Details of the resource scope
     */
    @JsonProperty(value = "scope")
    private ExpandedPropertiesScope scope;

    /*
     * Details of role definition
     */
    @JsonProperty(value = "roleDefinition")
    private ExpandedPropertiesRoleDefinition roleDefinition;

    /*
     * Details of the principal
     */
    @JsonProperty(value = "principal")
    private ExpandedPropertiesPrincipal principal;

    /**
     * Get the scope property: Details of the resource scope.
     *
     * @return the scope value.
     */
    public ExpandedPropertiesScope scope() {
        return this.scope;
    }

    /**
     * Set the scope property: Details of the resource scope.
     *
     * @param scope the scope value to set.
     * @return the ExpandedProperties object itself.
     */
    public ExpandedProperties withScope(ExpandedPropertiesScope scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the roleDefinition property: Details of role definition.
     *
     * @return the roleDefinition value.
     */
    public ExpandedPropertiesRoleDefinition roleDefinition() {
        return this.roleDefinition;
    }

    /**
     * Set the roleDefinition property: Details of role definition.
     *
     * @param roleDefinition the roleDefinition value to set.
     * @return the ExpandedProperties object itself.
     */
    public ExpandedProperties withRoleDefinition(ExpandedPropertiesRoleDefinition roleDefinition) {
        this.roleDefinition = roleDefinition;
        return this;
    }

    /**
     * Get the principal property: Details of the principal.
     *
     * @return the principal value.
     */
    public ExpandedPropertiesPrincipal principal() {
        return this.principal;
    }

    /**
     * Set the principal property: Details of the principal.
     *
     * @param principal the principal value to set.
     * @return the ExpandedProperties object itself.
     */
    public ExpandedProperties withPrincipal(ExpandedPropertiesPrincipal principal) {
        this.principal = principal;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scope() != null) {
            scope().validate();
        }
        if (roleDefinition() != null) {
            roleDefinition().validate();
        }
        if (principal() != null) {
            principal().validate();
        }
    }
}
